/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator.validation;

import ch.ralscha.extdirectspring.generator.IncludeValidation;
import ch.ralscha.extdirectspring.generator.ModelBean;
import ch.ralscha.extdirectspring.generator.ModelFieldBean;
import ch.ralscha.extdirectspring.generator.validation.CreditCardNumberValidation;
import ch.ralscha.extdirectspring.generator.validation.DigitsValidation;
import ch.ralscha.extdirectspring.generator.validation.EmailValidation;
import ch.ralscha.extdirectspring.generator.validation.FormatValidation;
import ch.ralscha.extdirectspring.generator.validation.FutureValidation;
import ch.ralscha.extdirectspring.generator.validation.LengthValidation;
import ch.ralscha.extdirectspring.generator.validation.NotBlankValidation;
import ch.ralscha.extdirectspring.generator.validation.PastValidation;
import ch.ralscha.extdirectspring.generator.validation.PresenceValidation;
import ch.ralscha.extdirectspring.generator.validation.RangeValidation;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AbstractValidation {
    private final String type;
    private final String field;

    public AbstractValidation(String type, String field) {
        this.type = type;
        this.field = field;
    }

    public String getType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public static void addValidationToModel(ModelBean model, ModelFieldBean modelFieldBean, Annotation fieldAnnotation, IncludeValidation includeValidation) {
        Number max;
        Number min;
        String annotationClassName = fieldAnnotation.annotationType().getName();
        if (includeValidation == IncludeValidation.BUILTIN || includeValidation == IncludeValidation.ALL) {
            if (annotationClassName.equals("javax.validation.constraints.NotNull") || annotationClassName.equals("org.hibernate.validator.constraints.NotEmpty")) {
                model.addValidation(new PresenceValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("javax.validation.constraints.Size") || annotationClassName.equals("org.hibernate.validator.constraints.Length")) {
                min = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"min");
                max = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"max");
                model.addValidation(new LengthValidation(modelFieldBean.getName(), (Integer)min, (Integer)max));
            } else if (annotationClassName.equals("javax.validation.constraints.Pattern")) {
                String regexp = (String)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"regexp");
                model.addValidation(new FormatValidation(modelFieldBean.getName(), regexp));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.Email")) {
                model.addValidation(new EmailValidation(modelFieldBean.getName()));
            }
        }
        if (includeValidation == IncludeValidation.ALL) {
            Object value;
            if (annotationClassName.equals("javax.validation.constraints.DecimalMax")) {
                value = (String)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), null, new BigDecimal((String)value)));
            } else if (annotationClassName.equals("javax.validation.constraints.DecimalMin")) {
                value = (String)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), new BigDecimal((String)value), null));
            } else if (annotationClassName.equals("javax.validation.constraints.Digits")) {
                Integer integer = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"integer");
                Integer fraction = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"fraction");
                model.addValidation(new DigitsValidation(modelFieldBean.getName(), integer, fraction));
            } else if (annotationClassName.equals("javax.validation.constraints.Future")) {
                model.addValidation(new FutureValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("javax.validation.constraints.Max")) {
                value = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), null, (Long)value));
            } else if (annotationClassName.equals("javax.validation.constraints.Min")) {
                value = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), (Long)value, null));
            } else if (annotationClassName.equals("javax.validation.constraints.Past")) {
                model.addValidation(new PastValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.CreditCardNumber")) {
                model.addValidation(new CreditCardNumberValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.NotBlank")) {
                model.addValidation(new NotBlankValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.Range")) {
                min = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"min");
                max = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"max");
                model.addValidation(new RangeValidation(modelFieldBean.getName(), (Long)min, (Long)max));
            }
        }
    }
}

