/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.generator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public enum ModelType {
    AUTO("auto"){

        @Override
        public boolean supports(Class<?> type) {
            return false;
        }
    }
    ,
    INTEGER("int"){

        @Override
        public boolean supports(Class<?> type) {
            return type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(BigInteger.class) || type.equals(Byte.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE);
        }
    }
    ,
    FLOAT("float"){

        @Override
        public boolean supports(Class<?> type) {
            return type.equals(Float.class) || type.equals(Double.class) || type.equals(BigDecimal.class) || type.equals(Float.TYPE) || type.equals(Double.TYPE);
        }
    }
    ,
    STRING("string"){

        @Override
        public boolean supports(Class<?> type) {
            return type.equals(String.class);
        }
    }
    ,
    DATE("date"){

        @Override
        public boolean supports(Class<?> type) {
            return type.equals(Date.class) || type.equals(java.sql.Date.class) || type.equals(Timestamp.class) || type.getName().equals("org.joda.time.DateTime") || type.getName().equals("org.joda.time.LocalDate") || Calendar.class.isAssignableFrom(type);
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        public boolean supports(Class<?> type) {
            return type.equals(Boolean.class) || type.equals(Boolean.TYPE);
        }
    };

    private String jsName;

    private ModelType(String jsName) {
        this.jsName = jsName;
    }

    public String getJsName() {
        return this.jsName;
    }

    public abstract boolean supports(Class<?> var1);
}

