/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean.api;

import ch.ralscha.extdirectspring.bean.api.Action;
import ch.ralscha.extdirectspring.bean.api.PollingProvider;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class RemotingApi {
    private String descriptor;
    private final String url;
    private final String namespace;
    private final String type;
    private final Map<String, List<Action>> actions;
    private Integer timeout;
    private Integer maxRetries;
    private Object enableBuffer;
    private final List<PollingProvider> pollingProviders;
    private final Map<String, List<String>> sseProviders;

    public RemotingApi(String type, String url, String namespace) {
        this.type = type;
        this.descriptor = null;
        this.actions = new HashMap<String, List<Action>>();
        this.pollingProviders = new ArrayList<PollingProvider>();
        this.sseProviders = new HashMap<String, List<String>>();
        this.url = url;
        this.namespace = StringUtils.hasText((String)namespace) ? namespace.trim() : null;
    }

    public Map<String, List<Action>> getActions() {
        return this.actions;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Object getEnableBuffer() {
        return this.enableBuffer;
    }

    public void setEnableBuffer(Object enableBuffer) {
        this.enableBuffer = enableBuffer;
    }

    @JsonIgnore
    public List<PollingProvider> getPollingProviders() {
        return this.pollingProviders;
    }

    @JsonIgnore
    public Map<String, List<String>> getSseProviders() {
        return this.sseProviders;
    }

    public void addAction(String beanName, Action action) {
        List<Action> beanActions = this.actions.get(beanName);
        if (beanActions == null) {
            beanActions = new ArrayList<Action>();
            this.actions.put(beanName, beanActions);
        }
        beanActions.add(action);
    }

    public void addPollingProvider(PollingProvider pollingProvider) {
        this.pollingProviders.add(pollingProvider);
    }

    public void addSseProvider(String beanName, String method) {
        List<String> methods = this.sseProviders.get(beanName);
        if (methods == null) {
            methods = new ArrayList<String>();
            this.sseProviders.put(beanName, methods);
        }
        methods.add(method);
    }
}

