/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceToRegexMapper;
import java.text.DateFormatSymbols;
import java.util.Locale;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CharSequenceToRegexMapperTest {
    static Locale KO_LOCALE = new Locale("ko", "KR");
    Locale oldLocale = Locale.getDefault();

    @After
    public void tearDown() {
        Locale.setDefault(this.oldLocale);
    }

    @Test
    public void findMinMaxLengthsInSymbolsWithTrivialInputs() {
        String[] symbols = new String[]{"a", "bb"};
        int[] results = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols((String[])symbols);
        Assert.assertEquals((long)1L, (long)results[0]);
        Assert.assertEquals((long)2L, (long)results[1]);
    }

    @Test
    public void emptyStringValuesShouldBeIgnoredByFindMinMaxLengthsInSymbols() {
        String[] symbols = new String[]{"aaa", ""};
        int[] results = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols((String[])symbols);
        Assert.assertEquals((long)3L, (long)results[0]);
        Assert.assertEquals((long)3L, (long)results[1]);
    }

    @Test
    @Ignore
    public void noneOfTheSymbolsAreOfZeroLengthForKorean() {
        Locale.setDefault(KO_LOCALE);
        this.noneOfTheSymbolsAreOfZeroLength();
    }

    @Test
    @Ignore
    public void noneOfTheSymbolsAreOfZeroLengthForSwiss() {
        Locale.setDefault(new Locale("fr", "CH"));
        this.noneOfTheSymbolsAreOfZeroLength();
    }

    private void noneOfTheSymbolsAreOfZeroLength() {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance();
        this.checkEmptyString(dateFormatSymbols.getShortWeekdays(), "ShortWeekdays");
        this.checkEmptyString(dateFormatSymbols.getWeekdays(), "Weekdays");
        this.checkEmptyString(dateFormatSymbols.getAmPmStrings(), "AmPmStrings");
    }

    private void checkEmptyString(String[] symbolArray, String category) {
        for (String s : symbolArray) {
            System.out.println(category + " [" + s + "]");
            Assert.assertTrue((String)(category + " contains empty strings"), (s.length() > 0 ? 1 : 0) != 0);
        }
    }
}

