/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.encoder.ByteArrayUtil;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ByteArrayUtilTest {
    int BA_SIZE = 16;
    byte[] byteArray = new byte[this.BA_SIZE];
    Random random = new Random(18532235L);

    @Test
    public void smoke() {
        this.verifyLoop(this.byteArray, 0, 0);
        this.verifyLoop(this.byteArray, 0, 10);
        this.verifyLoop(this.byteArray, 0, Integer.MAX_VALUE);
        this.verifyLoop(this.byteArray, 0, Integer.MIN_VALUE);
    }

    @Test
    public void random() {
        for (int i = 0; i < 100000; ++i) {
            int rOffset = this.random.nextInt(this.BA_SIZE - 4);
            int rInt = this.random.nextInt();
            this.verifyLoop(this.byteArray, rOffset, rInt);
        }
    }

    void verifyLoop(byte[] ba, int offset, int expected) {
        ByteArrayUtil.writeInt((byte[])this.byteArray, (int)offset, (int)expected);
        int back = ByteArrayUtil.readInt((byte[])this.byteArray, (int)offset);
        Assert.assertEquals((long)expected, (long)back);
    }
}

