/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timesmapStr = null;
    SimpleDateFormat simpleFormat = null;

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.simpleFormat = new SimpleDateFormat(datePattern);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e);
            this.simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        }
        List optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone((String)optionList.get(1));
            this.simpleFormat.setTimeZone(tz);
        }
    }

    public String convert(Object event) {
        LoggingEvent le = (LoggingEvent)event;
        long timestamp = le.getTimeStamp();
        if (timestamp == this.lastTimestamp) {
            return this.timesmapStr;
        }
        this.lastTimestamp = timestamp;
        this.timesmapStr = this.simpleFormat.format(new Date(timestamp));
        return this.timesmapStr;
    }
}

