/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;

public class ByteBufferDataOutputStream
extends OutputStream
implements DataOutput {
    private ByteBuffer buf;
    private DataOutput utfEncoder;

    public ByteBufferDataOutputStream(ByteBuffer buf) {
        Preconditions.checkArgument((!buf.isReadOnly() ? 1 : 0) != 0, (Object)"read-only buffer");
        this.buf = buf;
    }

    private static RuntimeException convertException(RuntimeException e) throws IOException {
        if (e instanceof BufferOverflowException) {
            throw (IOException)new EOFException().initCause(e);
        }
        if (e instanceof NullPointerException) {
            throw new ClosedChannelException();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.buf = null;
            this.utfEncoder = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this.buf instanceof MappedByteBuffer) {
            try {
                ((MappedByteBuffer)this.buf).force();
            }
            catch (RuntimeException e) {
                throw ByteBufferDataOutputStream.convertException(e);
            }
        }
    }

    public final ByteBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull((Object)b);
        try {
            this.buf.put(b, off, len);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void write(int b) throws IOException {
        try {
            this.buf.put((byte)b);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    @Deprecated
    public final void writeBytes(String s) throws IOException {
        Preconditions.checkNotNull((Object)s);
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.buf.put((byte)s.charAt(i));
            }
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeChar(int v) throws IOException {
        try {
            this.buf.putChar((char)v);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeChars(String s) throws IOException {
        Preconditions.checkNotNull((Object)s);
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.buf.putChar(s.charAt(i));
            }
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        try {
            this.buf.putDouble(v);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        try {
            this.buf.putFloat(v);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeInt(int v) throws IOException {
        try {
            this.buf.putInt(v);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeLong(long v) throws IOException {
        try {
            this.buf.putLong(v);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeShort(int v) throws IOException {
        try {
            this.buf.putShort((short)v);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataOutputStream.convertException(e);
        }
    }

    @Override
    public final void writeUTF(String s) throws IOException {
        Preconditions.checkNotNull((Object)s);
        if (this.utfEncoder == null) {
            this.utfEncoder = new DataOutputStream(this);
        }
        this.utfEncoder.writeUTF(s);
    }
}

