/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class ByteBufferDataInputStream
extends InputStream
implements DataInput {
    private ByteBuffer buf;

    private static RuntimeException convertException(RuntimeException e) throws IOException {
        if (e instanceof BufferUnderflowException) {
            throw (IOException)new EOFException().initCause(e);
        }
        if (e instanceof NullPointerException) {
            throw new ClosedChannelException();
        }
        return e;
    }

    public ByteBufferDataInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public final int available() throws IOException {
        try {
            return this.buf.remaining();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final void close() throws IOException {
        this.buf = null;
    }

    public final ByteBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public final int read() throws IOException {
        try {
            if (this.buf.remaining() == 0) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull((Object)b);
        try {
            int remain = this.buf.remaining();
            if (remain == 0) {
                return -1;
            }
            int actualLen = Math.min(len, remain);
            this.buf.get(b, off, actualLen);
            return actualLen;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final boolean readBoolean() throws IOException {
        try {
            return this.buf.get() != 0;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final byte readByte() throws IOException {
        try {
            return this.buf.get();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final char readChar() throws IOException {
        try {
            return this.buf.getChar();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final double readDouble() throws IOException {
        try {
            return this.buf.getDouble();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final float readFloat() throws IOException {
        try {
            return this.buf.getFloat();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final void readFully(byte[] b) throws IOException {
        try {
            this.buf.get(b);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        Preconditions.checkNotNull((Object)b);
        try {
            this.buf.get(b, off, len);
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final int readInt() throws IOException {
        try {
            return this.buf.getInt();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        StringBuilder sbuf = null;
        try {
            byte b;
            while ((b = this.buf.get()) != 10) {
                if (sbuf == null) {
                    sbuf = new StringBuilder();
                }
                if (b == 13) continue;
                sbuf.append((char)b);
            }
        }
        catch (BufferUnderflowException ignore) {
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
        return sbuf != null ? sbuf.toString() : null;
    }

    @Override
    public final long readLong() throws IOException {
        try {
            return this.buf.getLong();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final short readShort() throws IOException {
        try {
            return this.buf.getShort();
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        try {
            return this.buf.get() & 0xFF;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        try {
            return this.buf.getShort() & 0xFFFF;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public final long skip(long n) throws IOException {
        try {
            int actualSkip = (int)Math.min(n, (long)this.buf.remaining());
            this.buf.position(this.buf.position() + actualSkip);
            return actualSkip;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        try {
            int limit = this.buf.limit();
            int curpos = this.buf.position();
            int actualn = Math.min(limit, n);
            this.buf.position(curpos + actualn);
            return actualn;
        }
        catch (RuntimeException e) {
            throw ByteBufferDataInputStream.convertException(e);
        }
    }
}

