/*
 * Decompiled with CFR 0.152.
 */
package ch.ledcom.jpreseed.distro;

import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@Immutable
@ThreadSafe
public class DistroVersion {
    private final String name;
    private final String shortName;
    private final String number;
    private final URI isoImageUri;
    private final URI usbImageUri;

    public DistroVersion(String name, String shortName, String number, URI isoImageUri, URI usbImageUri) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Version name cannot be null");
        this.shortName = (String)Preconditions.checkNotNull((Object)shortName, (Object)"Short name cannot be null");
        this.number = (String)Preconditions.checkNotNull((Object)number, (Object)"Version number cannot be null");
        this.isoImageUri = (URI)Preconditions.checkNotNull((Object)isoImageUri, (Object)"ISO image URI cannot be null");
        this.usbImageUri = (URI)Preconditions.checkNotNull((Object)usbImageUri, (Object)"USB image URI cannot be null");
    }

    public final String getName() {
        return this.name;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getNumber() {
        return this.number;
    }

    public final URI getIsoImageUri() {
        return this.isoImageUri;
    }

    public final URI getUsbImageUri() {
        return this.usbImageUri;
    }

    public final String toString() {
        return this.name;
    }
}

