/*
 * Decompiled with CFR 0.152.
 */
package ch.ledcom.jpreseed.distro;

import ch.ledcom.jpreseed.distro.Distribution;
import ch.ledcom.jpreseed.distro.DistroAndVersion;
import ch.ledcom.jpreseed.distro.DistroVersion;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class DistroService {
    private final ImmutableMap<String, Distribution> distributionsByName;
    private final ImmutableList<DistroAndVersion> flattenedVersions;

    public DistroService(List<Distribution> distributions) {
        ImmutableMap.Builder byNameBuilder = ImmutableMap.builder();
        ImmutableList.Builder flattenedBuilder = ImmutableList.builder();
        for (Distribution distro : distributions) {
            byNameBuilder.put((Object)distro.getName(), (Object)distro);
            for (DistroVersion version : distro.getVersions()) {
                flattenedBuilder.add((Object)new DistroAndVersion(distro, version));
            }
        }
        this.distributionsByName = byNameBuilder.build();
        this.flattenedVersions = flattenedBuilder.build();
    }

    public final Distribution getDistributionByName(String name) {
        return (Distribution)this.distributionsByName.get((Object)name);
    }

    public final ImmutableCollection<Distribution> getDistributions() {
        return this.distributionsByName.values();
    }

    public final ImmutableList<DistroAndVersion> getFlattenedVersions() {
        return this.flattenedVersions;
    }

    public static DistroService create(InputStream configuration) throws URISyntaxException {
        ImmutableList.Builder distributions = ImmutableList.builder();
        Map yaml = (Map)new Yaml().load(configuration);
        for (Map.Entry distribution : yaml.entrySet()) {
            distributions.add((Object)new Distribution((String)distribution.getKey(), DistroService.extractVersions((Map)distribution.getValue())));
        }
        return new DistroService((List<Distribution>)distributions.build());
    }

    private static List<DistroVersion> extractVersions(Map<String, Map<String, String>> versions) throws URISyntaxException {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map.Entry<String, Map<String, String>> version : versions.entrySet()) {
            String name = version.getKey();
            Map<String, String> fields = version.getValue();
            String shortName = fields.get("shortName");
            String number = fields.get("number");
            URI isoImageUri = new URI(fields.get("isoImage"));
            URI usbImageUri = new URI(fields.get("usbImage"));
            result.add((Object)new DistroVersion(name, shortName, number, isoImageUri, usbImageUri));
        }
        return result.build();
    }
}

