/*
 * Decompiled with CFR 0.152.
 */
package ch.ledcom.jpreseed.distro;

import ch.ledcom.jpreseed.distro.DistroVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;

@Immutable
@ThreadSafe
public class Distribution {
    private final String name;
    private final ImmutableList<DistroVersion> versions;
    private final ImmutableMap<String, DistroVersion> versionsByName;
    private final ImmutableMap<String, DistroVersion> versionsByShortName;
    private final ImmutableMap<String, DistroVersion> versionsByNumber;

    public Distribution(String name, List<DistroVersion> versions) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Distribution name cannot be null");
        ImmutableMap.Builder byNameBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byShortNameBuilder = ImmutableMap.builder();
        ImmutableMap.Builder byNumberBuilder = ImmutableMap.builder();
        for (DistroVersion version : versions) {
            byNameBuilder.put((Object)version.getName(), (Object)version);
            byShortNameBuilder.put((Object)version.getShortName(), (Object)version);
            byNumberBuilder.put((Object)version.getNumber(), (Object)version);
        }
        this.versions = ImmutableList.copyOf(versions);
        this.versionsByName = byNameBuilder.build();
        this.versionsByShortName = byShortNameBuilder.build();
        this.versionsByNumber = byNumberBuilder.build();
    }

    public final String getName() {
        return this.name;
    }

    public final ImmutableList<DistroVersion> getVersions() {
        return this.versions;
    }

    public final DistroVersion getVersionByName(String name) {
        return (DistroVersion)this.versionsByName.get((Object)name);
    }

    public final DistroVersion getVersionByShortName(String shortName) {
        return (DistroVersion)this.versionsByShortName.get((Object)shortName);
    }

    public final DistroVersion getVersionByNumber(String number) {
        return (DistroVersion)this.versionsByNumber.get((Object)number);
    }

    public final String toString() {
        return this.name;
    }
}

