/*
 * Decompiled with CFR 0.152.
 */
package ch.ledcom.jpreseed;

import ch.ledcom.jpreseed.FatModifier;
import ch.ledcom.jpreseed.InitrdRepacker;
import com.google.common.io.ByteBufferDataInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.zip.GZIPOutputStream;

public class UsbCreator {
    public static final String INITRD_GZ = "initrd.gz";
    public static final String SYSLINUX_CFG = "syslinux.cfg";

    public final void create(InputStream srcBootImgGz, GZIPOutputStream targetBootImg, ByteBuffer sysLinuxCfg, Collection<Path> preseedFiles) throws IOException {
        try (FatModifier fatModifier = new FatModifier(srcBootImgGz);){
            ByteBuffer srcInitrdGz = fatModifier.getFileContent(INITRD_GZ);
            srcInitrdGz.rewind();
            fatModifier.addOrReplace(INITRD_GZ, this.repackedInitrd(srcInitrdGz, preseedFiles));
            fatModifier.addOrReplace(SYSLINUX_CFG, sysLinuxCfg);
            fatModifier.flush();
            targetBootImg.write(fatModifier.getByteBuffer().array());
        }
    }

    private ByteBuffer repackedInitrd(ByteBuffer srcInitrdGz, Collection<Path> preseedFiles) throws IOException {
        ByteArrayOutputStream newInitrd = new ByteArrayOutputStream();
        InitrdRepacker initrdRepacker = new InitrdRepacker(new ByteBufferDataInputStream(srcInitrdGz));
        for (Path preseedFile : preseedFiles) {
            initrdRepacker.addFile(preseedFile.getFileName().toString(), preseedFile.toFile());
        }
        initrdRepacker.repack(newInitrd);
        return ByteBuffer.wrap(newInitrd.toByteArray());
    }
}

