/*
 * Decompiled with CFR 0.152.
 */
package ch.ledcom.jpreseed;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitrdRepacker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InputStream initrdGz;
    private final Map<String, File> additionalFiles = new HashMap<String, File>();

    public InitrdRepacker(InputStream initrdGz) {
        this.initrdGz = initrdGz;
    }

    public final InitrdRepacker addFile(String name, File content) {
        this.additionalFiles.put(name, content);
        return this;
    }

    public final void repack(OutputStream out) throws IOException {
        try (CpioArchiveInputStream cpioIn = new CpioArchiveInputStream((InputStream)new GZIPInputStream(this.initrdGz));
             CpioArchiveOutputStream cpioOut = new CpioArchiveOutputStream((OutputStream)new GZIPOutputStream(out));){
            CpioArchiveEntry cpioEntry;
            while ((cpioEntry = cpioIn.getNextCPIOEntry()) != null) {
                if (this.additionalFiles.keySet().contains(cpioEntry.getName())) continue;
                this.logger.info("Repacking [{}]", (Object)cpioEntry.getName());
                cpioOut.putArchiveEntry((ArchiveEntry)cpioEntry);
                long bytesCopied = ByteStreams.copy((InputStream)cpioIn, (OutputStream)cpioOut);
                cpioOut.closeArchiveEntry();
                this.logger.debug("Copied [{}] bytes", (Object)bytesCopied);
            }
            for (Map.Entry<String, File> entry : this.additionalFiles.entrySet()) {
                this.logger.info("Packing new file [{}]", (Object)entry.getKey());
                ArchiveEntry additionalEntry = cpioOut.createArchiveEntry(entry.getValue(), entry.getKey());
                cpioOut.putArchiveEntry(additionalEntry);
                try (FileInputStream in = new FileInputStream(entry.getValue());){
                    ByteStreams.copy((InputStream)in, (OutputStream)cpioOut);
                }
                cpioOut.closeArchiveEntry();
            }
        }
    }
}

