/*
 * Decompiled with CFR 0.152.
 */
package ch.ledcom.jpreseed;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.FileSystem;
import de.waldheinz.fs.FileSystemFactory;
import de.waldheinz.fs.FsDirectoryEntry;
import de.waldheinz.fs.FsFile;
import de.waldheinz.fs.util.RamDisk;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class FatModifier
implements Closeable {
    private final FileSystem fileSystem;
    private final RamDisk ramDisk;

    public FatModifier(InputStream gzippedFat) throws IOException {
        this.ramDisk = RamDisk.readGzipped((InputStream)gzippedFat);
        this.fileSystem = FileSystemFactory.create((BlockDevice)this.ramDisk, (boolean)false);
    }

    public final ByteBuffer getFileContent(String fileName) throws IOException {
        FsDirectoryEntry entry = this.fileSystem.getRoot().getEntry(fileName);
        if (entry == null) {
            throw new FileNotFoundException(fileName);
        }
        if (!entry.isFile()) {
            throw new IOException(String.format("Can only get getContent of files and [%s] is not a file.", fileName));
        }
        FsFile file = entry.getFile();
        ByteBuffer buffer = ByteBuffer.allocate((int)file.getLength());
        file.read(0L, buffer);
        return buffer;
    }

    public final void addOrReplace(String name, ByteBuffer content) throws IOException {
        FsDirectoryEntry entry = this.fileSystem.getRoot().getEntry(name);
        if (entry == null) {
            entry = this.fileSystem.getRoot().addFile(name);
        }
        if (!entry.isFile()) {
            throw new IllegalStateException(String.format("Entry [%s] already exists and is a directory, not a file.", name));
        }
        entry.getFile().write(0L, content);
    }

    public final ByteBuffer getByteBuffer() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)this.ramDisk.getSize());
        this.ramDisk.read(0L, buffer);
        return buffer;
    }

    @Override
    public final void close() throws IOException {
        this.fileSystem.close();
    }

    public final boolean isClosed() {
        return this.fileSystem.isClosed();
    }

    public final void flush() throws IOException {
        this.fileSystem.flush();
    }
}

