/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash.util;

import ch.hsr.geohash.BoundingBox;

public class GeoHashSizeTable {
    private static final int NUM_BITS = 64;
    private static final double[] dLat = new double[64];
    private static final double[] dLon = new double[64];

    protected static final double dLat(int bits) {
        return 180.0 / Math.pow(2.0, bits / 2);
    }

    protected static final double dLon(int bits) {
        return 360.0 / Math.pow(2.0, (bits + 1) / 2);
    }

    public static final int numberOfBitsForOverlappingGeoHash(BoundingBox boundingBox) {
        int bits;
        double height = boundingBox.getLatitudeSize();
        double width = boundingBox.getLongitudeSize();
        for (bits = 63; (dLat[bits] < height || dLon[bits] < width) && bits > 0; --bits) {
        }
        return bits;
    }

    static {
        for (int i = 0; i < 64; ++i) {
            GeoHashSizeTable.dLat[i] = GeoHashSizeTable.dLat(i);
            GeoHashSizeTable.dLon[i] = GeoHashSizeTable.dLon(i);
        }
    }
}

