/*
 * Decompiled with CFR 0.152.
 */
package cc.spray.caching;

import akka.dispatch.ExecutionContext;
import akka.dispatch.Future;
import akka.dispatch.Promise;
import akka.dispatch.Promise$;
import cc.spray.caching.Cache;
import cc.spray.caching.Cache$class;
import cc.spray.caching.Entry;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0005%\u0011\u0001#\u0012=qSJLgn\u001a'sk\u000e\u000b7\r[3\u000b\u0005\r!\u0011aB2bG\"Lgn\u001a\u0006\u0003\u000b\u0019\tQa\u001d9sCfT\u0011aB\u0001\u0003G\u000e\u001c\u0001!\u0006\u0002\u000b3M!\u0001aC\n&!\ta\u0011#D\u0001\u000e\u0015\tqq\"\u0001\u0003mC:<'\"\u0001\t\u0002\t)\fg/Y\u0005\u0003%5\u0011aa\u00142kK\u000e$\bc\u0001\u000b\u0016/5\t!!\u0003\u0002\u0017\u0005\t)1)Y2iKB\u0011\u0001$\u0007\u0007\u0001\t\u0015Q\u0002A1\u0001\u001c\u0005\u00051\u0016C\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!H\u0012\n\u0005\u0011r\"aA!osB\u0011QDJ\u0005\u0003Oy\u00111bU2bY\u0006|%M[3di\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0006nCb\u001c\u0015\r]1dSRL\bCA\u000f,\u0013\tacDA\u0002J]RD\u0001B\f\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0010S:LG/[1m\u0007\u0006\u0004\u0018mY5us\"A\u0001\u0007\u0001B\u0001B\u0003%\u0011'\u0001\u0006uS6,Gk\u001c'jm\u0016\u0004\"!\b\u001a\n\u0005Mr\"\u0001\u0002'p]\u001eD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006I!M\u0001\u000bi&lW\rV8JI2,\u0007\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\bF\u0003:umbT\bE\u0002\u0015\u0001]AQ!\u000b\u001cA\u0002)BQA\f\u001cA\u0002)BQ\u0001\r\u001cA\u0002EBQ!\u000e\u001cA\u0002EB\u0001b\u0010\u0001C\u0002\u0013\u0005!\u0001Q\u0001\u0006gR|'/Z\u000b\u0002\u0003B!!)\u0013\u0012L\u001b\u0005\u0019%B\u0001#F\u0003]\u0019wN\\2veJ,g\u000e\u001e7j].,G\r[1tQ6\f\u0007O\u0003\u0002G\u000f\u0006Qqm\\8hY\u0016\u001cw\u000eZ3\u000b\u0003!\u000b1aY8n\u0013\tQ5IA\fD_:\u001cWO\u001d:f]Rd\u0015N\\6fI\"\u000b7\u000f['baB\u0019A\u0003T\f\n\u00055\u0013!!B#oiJL\bBB(\u0001A\u0003%\u0011)\u0001\u0004ti>\u0014X\r\t\u0005\u0006#\u0002!\tAU\u0001\u0004O\u0016$HCA*_!\riBKV\u0005\u0003+z\u0011aa\u00149uS>t\u0007cA,]/5\t\u0001L\u0003\u0002Z5\u0006AA-[:qCR\u001c\u0007NC\u0001\\\u0003\u0011\t7n[1\n\u0005uC&A\u0002$viV\u0014X\rC\u0003`!\u0002\u0007!%A\u0002lKfD#\u0001U1\u0011\u0005\t,W\"A2\u000b\u0005\u0011t\u0012AC1o]>$\u0018\r^5p]&\u0011am\u0019\u0002\bi\u0006LGN]3d\u0011\u0015A\u0007\u0001\"\u0001j\u0003)1'o\\7GkR,(/\u001a\u000b\u0003UZ$\"a[9\u0015\u0005Yc\u0007\"B7h\u0001\bq\u0017\u0001C3yK\u000e,Ho\u001c:\u0011\u0005]{\u0017B\u00019Y\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004sO\u0012\u0005\ra]\u0001\u0007MV$XO]3\u0011\u0007u!h+\u0003\u0002v=\tAAHY=oC6,g\bC\u0003`O\u0002\u0007!\u0005C\u0003y\u0001\u0011\u0005\u00110\u0001\u0004sK6|g/\u001a\u000b\u0003'jDQaX<A\u0002\tBQ\u0001 \u0001\u0005\u0002u\fQa\u00197fCJ$\u0012A \t\u0003;}L1!!\u0001\u001f\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u00059\u0011n]!mSZ,G\u0003BA\u0005\u0003\u001f\u00012!HA\u0006\u0013\r\tiA\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\"a\u0001A\u0002-\u000bQ!\u001a8uef\u0004")
public final class ExpiringLruCache<V>
implements Cache<V>,
ScalaObject {
    private final long timeToLive;
    private final long timeToIdle;
    private final ConcurrentLinkedHashMap<Object, Entry<V>> store;

    public ConcurrentLinkedHashMap<Object, Entry<V>> store() {
        return this.store;
    }

    @Override
    public Option<Future<V>> get(Object key) {
        None$ none$;
        block3: {
            Entry entry;
            do {
                if ((entry = (Entry)this.store().get(key)) == null) {
                    none$ = None$.MODULE$;
                } else {
                    Entry entry2 = entry;
                    if (!this.gd1$1(entry2)) continue;
                    entry2.refresh();
                    none$ = new Some(entry2.promise());
                }
                break block3;
            } while (!this.store().remove(key, (Object)entry));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Future<V> fromFuture(Object key$2, Function0<Future<V>> future$1, ExecutionContext executor$1) {
        Future future;
        Entry entry = (Entry)this.store().get(key$2);
        if (entry == null) {
            future = this.insert$1(key$2, future$1, executor$1);
        } else {
            Entry entry2 = entry;
            if (this.gd2$1(entry2)) {
                entry2.refresh();
                future = entry2.promise();
            } else {
                future = this.insert$1(key$2, future$1, executor$1);
            }
        }
        return future;
    }

    @Override
    public Option<Future<V>> remove(Object key) {
        Entry entry;
        Entry entry2 = (Entry)this.store().remove(key);
        return entry2 == null ? None$.MODULE$ : (this.gd3$1(entry = entry2) ? new Some(entry.promise()) : None$.MODULE$);
    }

    @Override
    public void clear() {
        this.store().clear();
    }

    private boolean isAlive(Entry<V> entry) {
        long now = System.currentTimeMillis();
        return !(this.timeToLive != 0L && now - entry.created() >= this.timeToLive || this.timeToIdle != 0L && now - entry.lastAccessed() >= this.timeToIdle);
    }

    private final boolean gd1$1(Entry entry) {
        return this.isAlive(entry);
    }

    private final Future insert$1(Object object, Function0 function0, ExecutionContext executionContext) {
        Promise promise;
        Entry newEntry$1 = new Entry(Promise$.MODULE$.apply(executionContext));
        Entry entry = (Entry)this.store().put(object, newEntry$1);
        if (entry == null) {
            promise = (Promise)function0.apply();
        } else {
            Entry entry2 = entry;
            if (this.isAlive(entry2)) {
                newEntry$1.created_$eq(entry2.created());
                promise = entry2.promise();
            } else {
                promise = (Future)function0.apply();
            }
        }
        Promise valueFuture = promise;
        return valueFuture.onComplete((Function1)new Serializable(this, object, newEntry$1){
            public static final long serialVersionUID;
            private final ExpiringLruCache $outer;
            private final Object key$2;
            private final Entry newEntry$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(Either<Throwable, V> value) {
                this.newEntry$1.promise().tryComplete(value);
                return value.isLeft() ? BoxesRunTime.boxToBoolean((boolean)this.$outer.store().remove(this.key$2, (Object)this.newEntry$1)) : BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.key$2 = expiringLruCache;
                this.newEntry$1 = var3_3;
            }
        });
    }

    private final boolean gd2$1(Entry entry) {
        return this.isAlive(entry);
    }

    private final boolean gd3$1(Entry entry) {
        return this.isAlive(entry);
    }

    public ExpiringLruCache(int maxCapacity, int initialCapacity, long timeToLive, long timeToIdle) {
        this.timeToLive = timeToLive;
        this.timeToIdle = timeToIdle;
        Cache$class.$init$(this);
        Predef$.MODULE$.require(timeToLive >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "timeToLive must not be negative";
            }
        });
        Predef$.MODULE$.require(timeToIdle >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "timeToIdle must not be negative";
            }
        });
        Predef$.MODULE$.require(timeToLive == 0L || timeToIdle == 0L || timeToLive > timeToIdle, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "timeToLive must be greater than timeToIdle, if both are non-zero";
            }
        });
        this.store = new ConcurrentLinkedHashMap.Builder().initialCapacity(initialCapacity).maximumWeightedCapacity(maxCapacity).build();
    }
}

