/*
 * Decompiled with CFR 0.152.
 */
package cc.spray.can.rendering;

import cc.spray.can.model.ChunkExtension;
import cc.spray.can.model.ChunkedMessageEnd;
import cc.spray.can.model.ChunkedRequestStart;
import cc.spray.can.model.HttpRequest;
import cc.spray.can.model.HttpRequestPart;
import cc.spray.can.model.MessageChunk;
import cc.spray.can.rendering.HttpRequestPartRenderingContext;
import cc.spray.can.rendering.MessageRendering;
import cc.spray.can.rendering.MessageRendering$;
import cc.spray.can.rendering.MessageRendering$class;
import cc.spray.can.rendering.RenderedMessagePart;
import cc.spray.can.rendering.RenderedMessagePart$;
import cc.spray.io.BufferBuilder;
import cc.spray.io.BufferBuilder$;
import java.nio.ByteBuffer;
import scala.MatchError;
import scala.Option;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u0017\ty!+Z9vKN$(+\u001a8eKJ,'O\u0003\u0002\u0004\t\u0005I!/\u001a8eKJLgn\u001a\u0006\u0003\u000b\u0019\t1aY1o\u0015\t9\u0001\"A\u0003taJ\f\u0017PC\u0001\n\u0003\t\u00197m\u0001\u0001\u0014\t\u0001aA\u0003\u0007\t\u0003\u001bIi\u0011A\u0004\u0006\u0003\u001fA\tA\u0001\\1oO*\t\u0011#\u0001\u0003kCZ\f\u0017BA\n\u000f\u0005\u0019y%M[3diB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0011\u001b\u0016\u001c8/Y4f%\u0016tG-\u001a:j]\u001e\u0004\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u00111bU2bY\u0006|%M[3di\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\bvg\u0016\u0014\u0018iZ3oi\"+\u0017\rZ3s!\t\tCE\u0004\u0002\u001aE%\u00111EG\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$5!A\u0001\u0006\u0001B\u0001B\u0003%\u0011&A\bsKF,Xm\u001d;TSj,\u0007*\u001b8u!\tI\"&\u0003\u0002,5\t\u0019\u0011J\u001c;\t\u000b5\u0002A\u0011\u0001\u0018\u0002\rqJg.\u001b;?)\ry\u0003'\r\t\u0003+\u0001AQa\b\u0017A\u0002\u0001BQ\u0001\u000b\u0017A\u0002%BQa\r\u0001\u0005\u0002Q\naA]3oI\u0016\u0014HCA\u001b9!\t)b'\u0003\u00028\u0005\t\u0019\"+\u001a8eKJ,G-T3tg\u0006<W\rU1si\")\u0011H\ra\u0001u\u0005\u00191\r\u001e=\u0011\u0005UY\u0014B\u0001\u001f\u0003\u0005}AE\u000f\u001e9SKF,Xm\u001d;QCJ$(+\u001a8eKJLgnZ\"p]R,\u0007\u0010\u001e\u0005\u0006}\u0001!IaP\u0001\u000ee\u0016tG-\u001a:SKF,Xm\u001d;\u0015\tU\u0002\u0005J\u0013\u0005\u0006\u0003v\u0002\rAQ\u0001\be\u0016\fX/Z:u!\t\u0019e)D\u0001E\u0015\t)E!A\u0003n_\u0012,G.\u0003\u0002H\t\nY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u0015IU\b1\u0001!\u0003\u0011Awn\u001d;\t\u000b-k\u0004\u0019A\u0015\u0002\tA|'\u000f\u001e\u0005\u0006\u001b\u0002!IAT\u0001\u001ae\u0016tG-\u001a:DQVt7.\u001a3SKF,Xm\u001d;Ti\u0006\u0014H\u000f\u0006\u00036\u001fB\u000b\u0006\"B!M\u0001\u0004\u0011\u0005\"B%M\u0001\u0004\u0001\u0003\"B&M\u0001\u0004I\u0003\"B*\u0001\t\u0013!\u0016A\u0005:f]\u0012,'OU3rk\u0016\u001cHo\u0015;beR$B!V.];B\u0011a+W\u0007\u0002/*\u0011\u0001LB\u0001\u0003S>L!AW,\u0003\u001b\t+hMZ3s\u0005VLG\u000eZ3s\u0011\u0015\t%\u000b1\u0001C\u0011\u0015I%\u000b1\u0001!\u0011\u0015Y%\u000b1\u0001*\u0001")
public class RequestRenderer
implements MessageRendering,
ScalaObject {
    private final String userAgentHeader;
    private final int requestSizeHint;

    public RenderedMessagePart render(HttpRequestPartRenderingContext ctx) {
        HttpRequestPart httpRequestPart;
        block6: {
            RenderedMessagePart renderedMessagePart;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            httpRequestPart = ctx.requestPart();
                            if (!(httpRequestPart instanceof HttpRequest)) break block2;
                            renderedMessagePart = this.renderRequest((HttpRequest)httpRequestPart, ctx.host(), ctx.port());
                            break block3;
                        }
                        if (!(httpRequestPart instanceof ChunkedRequestStart)) break block4;
                        renderedMessagePart = this.renderChunkedRequestStart(((ChunkedRequestStart)httpRequestPart).request(), ctx.host(), ctx.port());
                        break block3;
                    }
                    if (!(httpRequestPart instanceof MessageChunk)) break block5;
                    renderedMessagePart = this.renderChunk((MessageChunk)httpRequestPart, this.requestSizeHint);
                    break block3;
                }
                if (!(httpRequestPart instanceof ChunkedMessageEnd)) break block6;
                renderedMessagePart = this.renderFinalChunk((ChunkedMessageEnd)httpRequestPart, this.requestSizeHint, (Option<String>)this.renderFinalChunk$default$3());
            }
            return renderedMessagePart;
        }
        throw new MatchError((Object)httpRequestPart);
    }

    private RenderedMessagePart renderRequest(HttpRequest request, String host, int port) {
        List list;
        BufferBuilder bb = this.renderRequestStart(request, host, port);
        int rbl = request.body().length;
        if (rbl > 0) {
            this.appendHeader("Content-Length", ((Object)BoxesRunTime.boxToInteger((int)rbl)).toString(), bb).append(MessageRendering$.MODULE$.CrLf());
            if (bb.remainingCapacity() >= rbl) {
                ByteBuffer byteBuffer = bb.append(request.body()).toByteBuffer();
                list = Nil$.MODULE$.$colon$colon((Object)byteBuffer);
            } else {
                ByteBuffer byteBuffer = bb.toByteBuffer();
                ByteBuffer byteBuffer2 = ByteBuffer.wrap(request.body());
                list = Nil$.MODULE$.$colon$colon((Object)byteBuffer2).$colon$colon((Object)byteBuffer);
            }
        } else {
            ByteBuffer byteBuffer = bb.append(MessageRendering$.MODULE$.CrLf()).toByteBuffer();
            list = Nil$.MODULE$.$colon$colon((Object)byteBuffer);
        }
        return new RenderedMessagePart((List<ByteBuffer>)list, RenderedMessagePart$.MODULE$.apply$default$2());
    }

    private RenderedMessagePart renderChunkedRequestStart(HttpRequest request, String host, int port) {
        BufferBuilder bb = this.renderRequestStart(request, host, port);
        this.appendHeader("Transfer-Encoding", "chunked", bb).append(MessageRendering$.MODULE$.CrLf());
        Object object = request.body().length > 0 ? this.renderChunk((List<ChunkExtension>)Nil$.MODULE$, request.body(), bb) : BoxedUnit.UNIT;
        ByteBuffer byteBuffer = bb.toByteBuffer();
        return new RenderedMessagePart((List<ByteBuffer>)Nil$.MODULE$.$colon$colon((Object)byteBuffer), RenderedMessagePart$.MODULE$.apply$default$2());
    }

    private BufferBuilder renderRequestStart(HttpRequest request, String host, int port) {
        BufferBuilder bb = BufferBuilder$.MODULE$.apply(this.requestSizeHint);
        bb.append(request.method().name()).append(' ').append(request.uri()).append(' ').append(request.protocol().name()).append(MessageRendering$.MODULE$.CrLf());
        this.appendHeaders(request.headers(), bb, (Option<String>)this.appendHeaders$default$3());
        bb.append("Host: ").append(host);
        Object object = port != 80 ? bb.append(':').append(Integer.toString(port)) : BoxedUnit.UNIT;
        bb.append(MessageRendering$.MODULE$.CrLf());
        Object object2 = this.userAgentHeader.isEmpty() ? BoxedUnit.UNIT : this.appendHeader("User-Agent", this.userAgentHeader, bb);
        return bb;
    }

    public RequestRenderer(String userAgentHeader, int requestSizeHint) {
        this.userAgentHeader = userAgentHeader;
        this.requestSizeHint = requestSizeHint;
        MessageRendering$class.$init$(this);
    }
}

