/*
 * Decompiled with CFR 0.152.
 */
package cc.spray.can.parsing;

import cc.spray.can.model.HttpHeader;
import cc.spray.can.model.MessageLine;
import cc.spray.can.parsing.CharacterParser;
import cc.spray.can.parsing.ErrorState;
import cc.spray.can.parsing.ErrorState$;
import cc.spray.can.parsing.HeaderNameParser;
import cc.spray.can.parsing.LwsParser;
import cc.spray.can.parsing.ParserSettings;
import cc.spray.can.parsing.ParsingState;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001q4A!\u0001\u0002\u0001\u0017\t\t\u0002*Z1eKJ4\u0016\r\\;f!\u0006\u00148/\u001a:\u000b\u0005\r!\u0011a\u00029beNLgn\u001a\u0006\u0003\u000b\u0019\t1aY1o\u0015\t9\u0001\"A\u0003taJ\f\u0017PC\u0001\n\u0003\t\u00197m\u0001\u0001\u0014\u0007\u0001a\u0001\u0003\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\ty1\t[1sC\u000e$XM\u001d)beN,'\u000f\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"CA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011M,G\u000f^5oON\u0004\"!D\r\n\u0005i\u0011!A\u0004)beN,'oU3ui&twm\u001d\u0005\t9\u0001\u0011\t\u0011)A\u0005;\u0005YQ.Z:tC\u001e,G*\u001b8f!\tq\u0012%D\u0001 \u0015\t\u0001C!A\u0003n_\u0012,G.\u0003\u0002#?\tYQ*Z:tC\u001e,G*\u001b8f\u0011!!\u0003A!A!\u0002\u0013)\u0013a\u00035fC\u0012,'oQ8v]R\u0004\"!\u0005\u0014\n\u0005\u001d\u0012\"aA%oi\"A\u0011\u0006\u0001B\u0001B\u0003%!&A\u0004iK\u0006$WM]:\u0011\u0007-\u001adG\u0004\u0002-c9\u0011Q\u0006M\u0007\u0002])\u0011qFC\u0001\u0007yI|w\u000e\u001e \n\u0003MI!A\r\n\u0002\u000fA\f7m[1hK&\u0011A'\u000e\u0002\u0005\u0019&\u001cHO\u0003\u00023%A\u0011adN\u0005\u0003q}\u0011!\u0002\u0013;ua\"+\u0017\rZ3s\u0011!Q\u0004A!b\u0001\n\u0003Y\u0014A\u00035fC\u0012,'OT1nKV\tA\b\u0005\u0002>\u0001:\u0011\u0011CP\u0005\u0003\u007fI\ta\u0001\u0015:fI\u00164\u0017BA!C\u0005\u0019\u0019FO]5oO*\u0011qH\u0005\u0005\t\t\u0002\u0011\t\u0011)A\u0005y\u0005Y\u0001.Z1eKJt\u0015-\\3!\u0011\u00151\u0005\u0001\"\u0001H\u0003\u0019a\u0014N\\5u}Q1\u0001*\u0013&L\u00196\u0003\"!\u0004\u0001\t\u000b])\u0005\u0019\u0001\r\t\u000bq)\u0005\u0019A\u000f\t\u000b\u0011*\u0005\u0019A\u0013\t\u000b%*\u0005\u0019\u0001\u0016\t\u000bi*\u0005\u0019\u0001\u001f\t\u000f=\u0003!\u0019!C\u0001!\u0006Y\u0001.Z1eKJ4\u0016\r\\;f+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011a\u0017M\\4\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\t\ri\u0003\u0001\u0015!\u0003R\u00031AW-\u00193feZ\u000bG.^3!\u0011\u001da\u0006\u00011A\u0005\u0002u\u000bQa\u001d9bG\u0016,\u0012A\u0018\t\u0003#}K!\u0001\u0019\n\u0003\u000f\t{w\u000e\\3b]\"9!\r\u0001a\u0001\n\u0003\u0019\u0017!C:qC\u000e,w\fJ3r)\t!w\r\u0005\u0002\u0012K&\u0011aM\u0005\u0002\u0005+:LG\u000fC\u0004iC\u0006\u0005\t\u0019\u00010\u0002\u0007a$\u0013\u0007\u0003\u0004k\u0001\u0001\u0006KAX\u0001\u0007gB\f7-\u001a\u0011\t\u000b1\u0004A\u0011A7\u0002\u00159\fW.\u001a)beN,'/F\u0001o!\tiq.\u0003\u0002q\u0005\t\u0001\u0002*Z1eKJt\u0015-\\3QCJ\u001cXM\u001d\u0005\u0006e\u0002!\ta]\u0001\u000bQ\u0006tG\r\\3DQ\u0006\u0014HC\u0001;x!\tiQ/\u0003\u0002w\u0005\ta\u0001+\u0019:tS:<7\u000b^1uK\")\u00010\u001da\u0001s\u000611-\u001e:t_J\u0004\"!\u0005>\n\u0005m\u0014\"\u0001B\"iCJ\u0004")
public class HeaderValueParser
extends CharacterParser
implements ScalaObject {
    private final ParserSettings settings;
    private final MessageLine messageLine;
    private final int headerCount;
    private final List<HttpHeader> headers;
    private final String headerName;
    private final java.lang.StringBuilder headerValue;
    private boolean space;

    public String headerName() {
        return this.headerName;
    }

    public java.lang.StringBuilder headerValue() {
        return this.headerValue;
    }

    public boolean space() {
        return this.space;
    }

    public void space_$eq(boolean bl) {
        this.space = bl;
    }

    public HeaderNameParser nameParser() {
        HttpHeader httpHeader = new HttpHeader(this.headerName(), this.headerValue().toString());
        return new HeaderNameParser(this.settings, this.messageLine, this.headerCount + 1, (List<HttpHeader>)this.headers.$colon$colon((Object)httpHeader));
    }

    @Override
    public ParsingState handleChar(char cursor) {
        ParsingState parsingState;
        if ((long)this.headerValue().length() <= Predef$.MODULE$.Long2long(this.settings.MaxHeaderValueLength())) {
            char c = cursor;
            switch (c) {
                default: {
                    if (this.space()) {
                        this.headerValue().append(' ');
                        this.space_$eq(false);
                    }
                    this.headerValue().append(cursor);
                    parsingState = this;
                    break;
                }
                case '\t': 
                case '\r': 
                case ' ': {
                    this.space_$eq(true);
                    parsingState = new LwsParser(this).handleChar(cursor);
                    break;
                }
                case '\n': {
                    if ((long)this.headerCount < Predef$.MODULE$.Long2long(this.settings.MaxHeaderCount())) {
                        parsingState = this.nameParser();
                        break;
                    }
                    parsingState = new ErrorState(new StringBuilder().append((Object)"HTTP message header count exceeds the configured limit of ").append((Object)this.settings.MaxHeaderCount()).toString(), 400);
                    break;
                }
            }
        } else {
            parsingState = new ErrorState(new StringBuilder().append((Object)"HTTP header value exceeds the configured limit of ").append((Object)this.settings.MaxHeaderValueLength()).append((Object)" characters (header '").append((Object)this.headerName()).append((Object)"')").toString(), ErrorState$.MODULE$.apply$default$2());
        }
        return parsingState;
    }

    public HeaderValueParser(ParserSettings settings, MessageLine messageLine, int headerCount, List<HttpHeader> headers, String headerName) {
        this.settings = settings;
        this.messageLine = messageLine;
        this.headerCount = headerCount;
        this.headers = headers;
        this.headerName = headerName;
        this.headerValue = new java.lang.StringBuilder();
        this.space = false;
    }
}

