/*
 * Decompiled with CFR 0.152.
 */
package cc.spray.can.parsing;

import cc.spray.can.model.ChunkExtension;
import cc.spray.can.model.HttpHeader;
import cc.spray.can.parsing.CharacterParser;
import cc.spray.can.parsing.ChunkBodyParser;
import cc.spray.can.parsing.ChunkBodyParser$;
import cc.spray.can.parsing.ChunkExtensionNameParser;
import cc.spray.can.parsing.ChunkExtensionNameParser$;
import cc.spray.can.parsing.ErrorState;
import cc.spray.can.parsing.ErrorState$;
import cc.spray.can.parsing.ParserSettings;
import cc.spray.can.parsing.ParsingState;
import cc.spray.can.parsing.TrailerParser;
import cc.spray.can.parsing.TrailerParser$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u0017\tY1\t[;oWB\u000b'o]3s\u0015\t\u0019A!A\u0004qCJ\u001c\u0018N\\4\u000b\u0005\u00151\u0011aA2b]*\u0011q\u0001C\u0001\u0006gB\u0014\u0018-\u001f\u0006\u0002\u0013\u0005\u00111mY\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011qb\u00115be\u0006\u001cG/\u001a:QCJ\u001cXM\u001d\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003!\u0019X\r\u001e;j]\u001e\u001c\bCA\u0007\u001a\u0013\tQ\"A\u0001\bQCJ\u001cXM]*fiRLgnZ:\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\tqr\u0004\u0005\u0002\u000e\u0001!)qc\u0007a\u00011!9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0013!C2ik:\\7+\u001b>f+\u0005\u0019\u0003CA\t%\u0013\t)#CA\u0002J]RDqa\n\u0001A\u0002\u0013\u0005\u0001&A\u0007dQVt7nU5{K~#S-\u001d\u000b\u0003S1\u0002\"!\u0005\u0016\n\u0005-\u0012\"\u0001B+oSRDq!\f\u0014\u0002\u0002\u0003\u00071%A\u0002yIEBaa\f\u0001!B\u0013\u0019\u0013AC2ik:\\7+\u001b>fA!)\u0011\u0007\u0001C\u0001e\u00051\u0001.\u00198eY\u0016$\"aM\u001d\u0013\u0007Q\u0002bG\u0002\u00036\u0001\u0001\u0019$\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA\u00078\u0013\tA$A\u0001\u0007QCJ\u001c\u0018N\\4Ti\u0006$X\rC\u0003;a\u0001\u00071%A\u0003eS\u001eLG\u000fC\u0003=\u0001\u0011\u0005Q(\u0001\u0006iC:$G.Z\"iCJ$\"A\u000e \t\u000b}Z\u0004\u0019\u0001!\u0002\r\r,(o]8s!\t\t\u0012)\u0003\u0002C%\t!1\t[1s\u0001")
public class ChunkParser
extends CharacterParser
implements ScalaObject {
    private final ParserSettings settings;
    private int chunkSize;

    public int chunkSize() {
        return this.chunkSize;
    }

    public void chunkSize_$eq(int n) {
        this.chunkSize = n;
    }

    public ScalaObject handle(int digit) {
        this.chunkSize_$eq(this.chunkSize() == -1 ? digit : this.chunkSize() * 16 + digit);
        return (long)this.chunkSize() > Predef$.MODULE$.Long2long(this.settings.MaxChunkSize()) ? new ErrorState(new StringBuilder().append((Object)"HTTP message chunk size exceeds the configured limit of ").append((Object)this.settings.MaxChunkSize()).append((Object)" bytes").toString(), ErrorState$.MODULE$.apply$default$2()) : this;
    }

    public ParsingState handleChar(char cursor$1) {
        ParsingState parsingState;
        char c = cursor$1;
        char x = c;
        if (this.gd1$1(x, cursor$1)) {
            parsingState = (ParsingState)this.handle(x - 48);
        } else {
            char x2 = c;
            if (this.gd2$1(x2, cursor$1)) {
                parsingState = (ParsingState)this.handle(x2 - 65 + 10);
            } else {
                char x3 = c;
                if (this.gd3$1(x3, cursor$1)) {
                    parsingState = (ParsingState)this.handle(x3 - 97 + 10);
                } else {
                    block0 : switch (c) {
                        default: {
                            parsingState = new ErrorState("Illegal chunk size", ErrorState$.MODULE$.apply$default$2());
                            break;
                        }
                        case ';': {
                            parsingState = new ChunkExtensionNameParser(this.settings, this.chunkSize(), ChunkExtensionNameParser$.MODULE$.init$default$3(), (List<ChunkExtension>)ChunkExtensionNameParser$.MODULE$.init$default$4());
                            break;
                        }
                        case '\t': 
                        case '\r': 
                        case ' ': {
                            parsingState = this;
                            break;
                        }
                        case '\n': {
                            int n = this.chunkSize();
                            switch (n) {
                                default: {
                                    parsingState = new ChunkBodyParser(this.settings, this.chunkSize(), (List<ChunkExtension>)ChunkBodyParser$.MODULE$.init$default$3());
                                    break block0;
                                }
                                case 0: {
                                    parsingState = new TrailerParser(this.settings, (List<ChunkExtension>)TrailerParser$.MODULE$.init$default$2(), TrailerParser$.MODULE$.init$default$3(), (List<HttpHeader>)TrailerParser$.MODULE$.init$default$4());
                                    break block0;
                                }
                                case -1: 
                            }
                            parsingState = new ErrorState("Chunk size expected", ErrorState$.MODULE$.apply$default$2());
                        }
                    }
                }
            }
        }
        return parsingState;
    }

    private final boolean gd1$1(char c, char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private final boolean gd2$1(char c, char c2) {
        return 'A' <= c2 && c2 <= 'F';
    }

    private final boolean gd3$1(char c, char c2) {
        return 'a' <= c2 && c2 <= 'f';
    }

    public ChunkParser(ParserSettings settings) {
        this.settings = settings;
        this.chunkSize = -1;
    }
}

