/*
 * Decompiled with CFR 0.152.
 */
package cc.spray.can.client;

import cc.spray.can.client.ClientSettings$;
import cc.spray.can.parsing.ParserSettings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4Q!\u0001\u0002\u0001\t)\u0011ab\u00117jK:$8+\u001a;uS:<7O\u0003\u0002\u0004\t\u000511\r\\5f]RT!!\u0002\u0004\u0002\u0007\r\fgN\u0003\u0002\b\u0011\u0005)1\u000f\u001d:bs*\t\u0011\"\u0001\u0002dGN\u0019\u0001aC\n\u0011\u00051\tR\"A\u0007\u000b\u00059y\u0011\u0001\u00027b]\u001eT\u0011\u0001E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0013\u001b\t1qJ\u00196fGR\u0004\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u00111bU2bY\u0006|%M[3di\"A!\u0004\u0001B\u0001B\u0003%A$\u0001\u0004d_:4\u0017nZ\u0002\u0001!\ti2%D\u0001\u001f\u0015\tQrD\u0003\u0002!C\u0005AA/\u001f9fg\u00064WMC\u0001#\u0003\r\u0019w.\\\u0005\u0003Iy\u0011aaQ8oM&<\u0007\"\u0002\u0014\u0001\t\u00039\u0013A\u0002\u001fj]&$h\b\u0006\u0002)UA\u0011\u0011\u0006A\u0007\u0002\u0005!9!$\nI\u0001\u0002\u0004a\u0002B\u0002\u0017\u0001A\u0003%A$A\u0001d\u0011\u001dq\u0003A1A\u0005\u0002=\nq\"V:fe\u0006;WM\u001c;IK\u0006$WM]\u000b\u0002aA\u0011A\"M\u0005\u0003e5\u0011aa\u0015;sS:<\u0007B\u0002\u001b\u0001A\u0003%\u0001'\u0001\tVg\u0016\u0014\u0018iZ3oi\"+\u0017\rZ3sA!9a\u0007\u0001b\u0001\n\u00039\u0014!D*T\u0019\u0016s7M]=qi&|g.F\u00019!\t!\u0012(\u0003\u0002;+\t9!i\\8mK\u0006t\u0007B\u0002\u001f\u0001A\u0003%\u0001(\u0001\bT'2+en\u0019:zaRLwN\u001c\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005Y\u0011\n\u001a7f)&lWm\\;u+\u0005\u0001\u0005C\u0001\u0007B\u0013\t\u0011UB\u0001\u0003M_:<\u0007B\u0002#\u0001A\u0003%\u0001)\u0001\u0007JI2,G+[7f_V$\b\u0005C\u0004G\u0001\t\u0007I\u0011A \u0002\u001dI+\u0017/^3tiRKW.Z8vi\"1\u0001\n\u0001Q\u0001\n\u0001\u000bqBU3rk\u0016\u001cH\u000fV5nK>,H\u000f\t\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001@\u00031\u0011V-\u00199j]\u001e\u001c\u0015p\u00197f\u0011\u0019a\u0005\u0001)A\u0005\u0001\u0006i!+Z1qS:<7)_2mK\u0002BqA\u0014\u0001C\u0002\u0013\u0005q'\u0001\u0005BG.\u001cVM\u001c3t\u0011\u0019\u0001\u0006\u0001)A\u0005q\u0005I\u0011iY6TK:$7\u000f\t\u0005\b%\u0002\u0011\r\u0011\"\u0001@\u0003u\u0011Vm\u001d9p]N,7\t[;oW\u0006;wM]3hCRLwN\u001c'j[&$\bB\u0002+\u0001A\u0003%\u0001)\u0001\u0010SKN\u0004xN\\:f\u0007\",hn[!hOJ,w-\u0019;j_:d\u0015.\\5uA!9a\u000b\u0001b\u0001\n\u0003y\u0014a\u0004*fcV,7\u000f^*ju\u0016D\u0015N\u001c;\t\ra\u0003\u0001\u0015!\u0003A\u0003A\u0011V-];fgR\u001c\u0016N_3IS:$\b\u0005C\u0004[\u0001\t\u0007I\u0011A.\u0002\u001dA\u000b'o]3s'\u0016$H/\u001b8hgV\tA\f\u0005\u0002^A6\taL\u0003\u0002`\t\u00059\u0001/\u0019:tS:<\u0017BA1_\u00059\u0001\u0016M]:feN+G\u000f^5oONDaa\u0019\u0001!\u0002\u0013a\u0016a\u0004)beN,'oU3ui&twm\u001d\u0011\b\u0011\u0015\u0014\u0011\u0011!E\u0003\t\u0019\fab\u00117jK:$8+\u001a;uS:<7\u000f\u0005\u0002*O\u001aA\u0011AAA\u0001\u0012\u000b!\u0001nE\u0002h\u0017MAQAJ4\u0005\u0002)$\u0012A\u001a\u0005\bY\u001e\f\n\u0011\"\u0001n\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uIE*\u0012A\u001c\u0016\u00039=\\\u0013\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005U,\u0012AC1o]>$\u0018\r^5p]&\u0011qO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClientSettings
implements ScalaObject {
    private final Config c;
    private final String UserAgentHeader;
    private final boolean SSLEncryption;
    private final Long IdleTimeout;
    private final Long RequestTimeout;
    private final Long ReapingCycle;
    private final boolean AckSends;
    private final Long ResponseChunkAggregationLimit;
    private final Long RequestSizeHint;
    private final ParserSettings ParserSettings;

    public static final Config init$default$1() {
        return ClientSettings$.MODULE$.init$default$1();
    }

    public String UserAgentHeader() {
        return this.UserAgentHeader;
    }

    public boolean SSLEncryption() {
        return this.SSLEncryption;
    }

    public Long IdleTimeout() {
        return this.IdleTimeout;
    }

    public Long RequestTimeout() {
        return this.RequestTimeout;
    }

    public Long ReapingCycle() {
        return this.ReapingCycle;
    }

    public boolean AckSends() {
        return this.AckSends;
    }

    public Long ResponseChunkAggregationLimit() {
        return this.ResponseChunkAggregationLimit;
    }

    public Long RequestSizeHint() {
        return this.RequestSizeHint;
    }

    public ParserSettings ParserSettings() {
        return this.ParserSettings;
    }

    public ClientSettings(Config config) {
        Config c = config.withFallback((ConfigMergeable)ConfigFactory.defaultReference());
        c.checkValid(ConfigFactory.defaultReference(), new String[]{"spray.can.client"});
        this.c = c.getConfig("spray.can.client");
        this.UserAgentHeader = this.c.getString("user-agent-header");
        this.SSLEncryption = this.c.getBoolean("ssl-encryption");
        this.IdleTimeout = this.c.getMilliseconds("idle-timeout");
        this.RequestTimeout = this.c.getMilliseconds("request-timeout");
        this.ReapingCycle = this.c.getMilliseconds("reaping-cycle");
        this.AckSends = this.c.getBoolean("ack-sends");
        this.ResponseChunkAggregationLimit = this.c.getBytes("response-chunk-aggregation-limit");
        this.RequestSizeHint = this.c.getBytes("request-size-hint");
        this.ParserSettings = new ParserSettings(this.c.getConfig("parsing"));
        Predef$.MODULE$.require(Predef$.MODULE$.Long2long(this.IdleTimeout()) >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "idle-timeout must be >= 0";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.Long2long(this.RequestTimeout()) >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "request-timeout must be >= 0";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.Long2long(this.ReapingCycle()) >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "reaping-cycle must be >= 0";
            }
        });
        Predef$.MODULE$.require(0L <= Predef$.MODULE$.Long2long(this.ResponseChunkAggregationLimit()) && Predef$.MODULE$.Long2long(this.ResponseChunkAggregationLimit()) <= Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "response-chunk-aggregation-limit must be >= 0 and <= Int.MaxValue";
            }
        });
        Predef$.MODULE$.require(0L <= Predef$.MODULE$.Long2long(this.RequestSizeHint()) && Predef$.MODULE$.Long2long(this.RequestSizeHint()) <= Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "request-size-hint must be >= 0 and <= Int.MaxValue";
            }
        });
    }
}

