/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;
import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.filter.ProxyChainScrutinizerFilter;
import edu.yale.its.tp.cas.client.filter.WatchfulFilterChain;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;

public class ProxyChainScrutinizerFilterTest
extends TestCase {
    private static final String GOOD_AUTHORIZED_PROXIES_STRING = "https://www.yale.edu/immediatelyPreviousServiceInChain https://www.princeton.edu/middleware https://www.northwestern.edu/userInitiallyAuthenticatedToThisApplication ; https://www.immediatelyPreviousAuthenticationProxyingService.com https://secure.com/middleTierService https://secure.com/userInterface";
    private ProxyChainScrutinizerFilter correctlyConfiguredFilter;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private WatchfulFilterChain filterChain;

    protected void setUp() throws Exception {
        super.setUp();
        MockFilterConfig config = new MockFilterConfig();
        MockServletContext context = new MockServletContext();
        context.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxyChains", GOOD_AUTHORIZED_PROXIES_STRING);
        config.setupServletContext((ServletContext)context);
        this.correctlyConfiguredFilter = new ProxyChainScrutinizerFilter();
        this.correctlyConfiguredFilter.init((FilterConfig)config);
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
        this.filterChain = new WatchfulFilterChain();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testInitNoParam() {
        MockFilterConfig config = new MockFilterConfig();
        MockServletContext context = new MockServletContext();
        config.setupServletContext((ServletContext)context);
        ProxyChainScrutinizerFilter filter = new ProxyChainScrutinizerFilter();
        try {
            filter.init((FilterConfig)config);
        }
        catch (ServletException e) {
            return;
        }
        ProxyChainScrutinizerFilterTest.fail((String)"Initialization should have failed because edu.yale.its.tp.cas.client.filter.authorizedProxyChains was not set.");
    }

    public void testEgregiouslyBadParam() {
        MockFilterConfig config = new MockFilterConfig();
        MockServletContext context = new MockServletContext();
        context.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxyChains", "wombat foobar splat");
        config.setupServletContext((ServletContext)context);
        ProxyChainScrutinizerFilter filter = new ProxyChainScrutinizerFilter();
        try {
            filter.init((FilterConfig)config);
        }
        catch (ServletException e) {
            return;
        }
        ProxyChainScrutinizerFilterTest.fail((String)"Initialization should have failed because edu.yale.its.tp.cas.client.filter.authorizedProxyChains had garbage values.");
    }

    public void testInsecureUrlsParam() {
        MockFilterConfig config = new MockFilterConfig();
        MockServletContext context = new MockServletContext();
        String badAuthorizedProxyChains = "https://www.yale.edu/bulldog https://www.princeton.edu/tiger https://www.northwestern.edu/wildcat ; https://www.beginSecondChain.com http://insecure.com/service https://secure.com/anotherService";
        context.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxyChains", badAuthorizedProxyChains);
        config.setupServletContext((ServletContext)context);
        ProxyChainScrutinizerFilter filter = new ProxyChainScrutinizerFilter();
        try {
            filter.init((FilterConfig)config);
        }
        catch (ServletException e) {
            return;
        }
        ProxyChainScrutinizerFilterTest.fail((String)"Initialization should have failed because edu.yale.its.tp.cas.client.filter.authorizedProxyChains contained an insecure URL.");
    }

    public void testEmptyParam() {
        MockFilterConfig config = new MockFilterConfig();
        MockServletContext context = new MockServletContext();
        context.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxyChains", "     ");
        config.setupServletContext((ServletContext)context);
        ProxyChainScrutinizerFilter filter = new ProxyChainScrutinizerFilter();
        try {
            filter.init((FilterConfig)config);
        }
        catch (ServletException e) {
            return;
        }
        ProxyChainScrutinizerFilterTest.fail((String)"Initialization should have failed because edu.yale.its.tp.cas.client.filter.authorizedProxyChains had only whitespace");
    }

    public void testGoodParam() throws ServletException {
        MockFilterConfig config = new MockFilterConfig();
        MockServletContext context = new MockServletContext();
        context.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxyChains", GOOD_AUTHORIZED_PROXIES_STRING);
        config.setupServletContext((ServletContext)context);
        ProxyChainScrutinizerFilter filter = new ProxyChainScrutinizerFilter();
        filter.init((FilterConfig)config);
    }

    public void testDoFilterNotHttpServletRequestNotHttpServletResponse() throws IOException {
        ServletRequestWrapper notHttpRequest = new ServletRequestWrapper((ServletRequest)this.request);
        ServletResponseWrapper notHttpResponse = new ServletResponseWrapper((ServletResponse)this.response);
        try {
            this.correctlyConfiguredFilter.doFilter((ServletRequest)notHttpRequest, (ServletResponse)notHttpResponse, this.filterChain);
        }
        catch (ServletException e) {
            return;
        }
        ProxyChainScrutinizerFilterTest.fail((String)"doFilter() should have failed because request was not an HttpServletRequest.");
    }

    public void testDoFilterNotHttpServletRequestButHttpServletResponse() throws IOException, ServletException {
        ServletRequestWrapper notHttpRequest = new ServletRequestWrapper((ServletRequest)this.request);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)notHttpRequest, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterNoSession() throws IOException, ServletException {
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterSessionButNoAttribute() throws IOException, ServletException {
        this.request.setSession((HttpSession)new MockHttpSession());
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterSessionAttributeOfWrongType() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)new ProxyChainScrutinizerFilter());
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterAuthorizedProxyChainOne() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        CASReceipt receipt = new CASReceipt();
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.yale.edu/immediatelyPreviousServiceInChain");
        proxyList.add("https://www.princeton.edu/middleware");
        proxyList.add("https://www.northwestern.edu/userInitiallyAuthenticatedToThisApplication");
        receipt.setProxyList(proxyList);
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)receipt);
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
    }

    public void testDoFilterAuthorizedProxyChainTwo() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        CASReceipt receipt = new CASReceipt();
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.immediatelyPreviousAuthenticationProxyingService.com");
        proxyList.add("https://secure.com/middleTierService");
        proxyList.add("https://secure.com/userInterface");
        receipt.setProxyList(proxyList);
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)receipt);
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
    }

    public void testDoFilterUnauthorizedProxyChain() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        CASReceipt receipt = new CASReceipt();
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.immediatelyPreviousAuthenticationProxyingService.com");
        proxyList.add("https://secure.com/middleTierService");
        proxyList.add("https://secure.com/notTheAuthorizedUserInterface");
        receipt.setProxyList(proxyList);
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)receipt);
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterPrefixOfAuthorizedChain() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        CASReceipt receipt = new CASReceipt();
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.immediatelyPreviousAuthenticationProxyingService.com");
        proxyList.add("https://secure.com/middleTierService");
        receipt.setProxyList(proxyList);
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)receipt);
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterSuffixOfAuthorizedChain() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        CASReceipt receipt = new CASReceipt();
        ArrayList<String> proxyList = new ArrayList<String>();
        proxyList.add("https://www.princeton.edu/middleware");
        proxyList.add("https://www.northwestern.edu/userInitiallyAuthenticatedToThisApplication");
        receipt.setProxyList(proxyList);
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)receipt);
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterServiceTicketReceipt() throws IOException, ServletException {
        MockHttpSession mockSession = new MockHttpSession();
        CASReceipt receipt = new CASReceipt();
        mockSession.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)receipt);
        this.request.setSession((HttpSession)mockSession);
        this.correctlyConfiguredFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertEquals((int)403, (int)this.response.getErrorCode());
    }

    public void testDoFilterAuthorizedServiceTicketReceipt() throws IOException, ServletException {
        String authorizedProxiesInitParam = "; https://www.yale.edu/immediatelyPreviousServiceInChain https://www.princeton.edu/middleware https://www.northwestern.edu/userInitiallyAuthenticatedToThisApplication ; https://www.immediatelyPreviousAuthenticationProxyingService.com https://secure.com/middleTierService https://secure.com/userInterface";
        MockServletContext context = new MockServletContext();
        context.setInitParameter("edu.yale.its.tp.cas.client.filter.authorizedProxyChains", authorizedProxiesInitParam);
        MockFilterConfig config = new MockFilterConfig();
        config.setupServletContext((ServletContext)context);
        ProxyChainScrutinizerFilter localFilter = new ProxyChainScrutinizerFilter();
        localFilter.init((FilterConfig)config);
        CASReceipt serviceTicketReceipt = new CASReceipt();
        MockHttpSession session = new MockHttpSession();
        session.setAttribute("edu.yale.its.tp.cas.client.filter.receipt", (Object)serviceTicketReceipt);
        this.request.setSession((HttpSession)session);
        localFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.filterChain);
        ProxyChainScrutinizerFilterTest.assertTrue((boolean)this.filterChain.isChainInvoked());
    }
}

