/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;

    protected ECPoint(ECCurve curve, ECFieldElement x, ECFieldElement y) {
        this.curve = curve;
        this.x = x;
        this.y = y;
    }

    public ECCurve getCurve() {
        return this.curve;
    }

    public ECFieldElement getX() {
        return this.x;
    }

    public ECFieldElement getY() {
        return this.y;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ECPoint)) {
            return false;
        }
        ECPoint o = (ECPoint)other;
        return this.x.equals(o.x) && this.y.equals(o.y);
    }

    public int hashCode() {
        return this.x.hashCode() ^ this.y.hashCode();
    }

    public abstract byte[] getEncoded();

    public abstract ECPoint add(ECPoint var1);

    public abstract ECPoint subtract(ECPoint var1);

    public abstract ECPoint twice();

    public abstract ECPoint multiply(BigInteger var1);

    public static class F2m
    extends ECPoint {
        protected F2m(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            super(curve, x, y);
        }

        public byte[] getEncoded() {
            return null;
        }

        public ECPoint add(ECPoint b) {
            return null;
        }

        public ECPoint subtract(ECPoint b) {
            return null;
        }

        public ECPoint twice() {
            return null;
        }

        public ECPoint multiply(BigInteger b) {
            return null;
        }
    }

    public static class Fp
    extends ECPoint {
        private boolean withCompression = true;

        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y) {
            super(curve, x, y);
        }

        public Fp(ECCurve curve, ECFieldElement x, ECFieldElement y, boolean withCompression) {
            super(curve, x, y);
            this.withCompression = withCompression;
        }

        private int getQLength(BigInteger p) {
            byte[] bytes = p.toByteArray();
            if (bytes[0] == 0) {
                return bytes.length - 1;
            }
            return bytes.length;
        }

        private byte[] intToBytes(BigInteger s, int qLength) {
            byte[] bytes = s.toByteArray();
            if (qLength < bytes.length) {
                byte[] tmp = new byte[qLength];
                System.arraycopy(bytes, bytes.length - tmp.length, tmp, 0, tmp.length);
                return tmp;
            }
            if (qLength > bytes.length) {
                byte[] tmp = new byte[qLength];
                System.arraycopy(bytes, 0, tmp, tmp.length - bytes.length, bytes.length);
                return tmp;
            }
            return bytes;
        }

        public byte[] getEncoded() {
            int qLength = this.getQLength(this.getX().p);
            if (this.withCompression) {
                int PC = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] X = this.intToBytes(this.getX().toBigInteger(), qLength);
                byte[] PO = new byte[X.length + 1];
                PO[0] = PC;
                System.arraycopy(X, 0, PO, 1, X.length);
                return PO;
            }
            byte[] X = this.intToBytes(this.getX().toBigInteger(), qLength);
            byte[] Y = this.intToBytes(this.getY().toBigInteger(), qLength);
            byte[] PO = new byte[X.length + Y.length + 1];
            PO[0] = 4;
            System.arraycopy(X, 0, PO, 1, X.length);
            System.arraycopy(Y, 0, PO, X.length + 1, Y.length);
            return PO;
        }

        public ECPoint add(ECPoint b) {
            ECFieldElement gamma = b.y.subtract(this.y).divide(b.x.subtract(this.x));
            ECFieldElement x3 = gamma.multiply(gamma).subtract(this.x).subtract(b.x);
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        public ECPoint twice() {
            ECFieldElement TWO = this.curve.fromBigInteger(BigInteger.valueOf(2L));
            ECFieldElement THREE = this.curve.fromBigInteger(BigInteger.valueOf(3L));
            ECFieldElement gamma = this.x.multiply(this.x).multiply(THREE).add(this.curve.a).divide(this.y.multiply(TWO));
            ECFieldElement x3 = gamma.multiply(gamma).subtract(this.x.multiply(TWO));
            ECFieldElement y3 = gamma.multiply(this.x.subtract(x3)).subtract(this.y);
            return new Fp(this.curve, x3, y3);
        }

        public ECPoint subtract(ECPoint p2) {
            return this.add(new Fp(this.curve, p2.x, p2.y.negate()));
        }

        public ECPoint multiply(BigInteger k) {
            BigInteger e = k;
            BigInteger h = e.multiply(BigInteger.valueOf(3L));
            ECPoint R = this;
            for (int i = h.bitLength() - 2; i > 0; --i) {
                R = R.twice();
                if (h.testBit(i) && !e.testBit(i)) {
                    R = R.add(this);
                    continue;
                }
                if (h.testBit(i) || !e.testBit(i)) continue;
                R = R.subtract(this);
            }
            return R;
        }
    }
}

