/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;

public class NullEngine
implements BlockCipher {
    protected static final int BLOCK_SIZE = 1;

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
    }

    public String getAlgorithmName() {
        return "Null";
    }

    public int getBlockSize() {
        return 1;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (inOff + 1 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 1 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        for (int i = 0; i < 1; ++i) {
            out[outOff + i] = in[inOff + i];
        }
        return 1;
    }

    public void reset() {
    }
}

