/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class CamelliaEngine
implements BlockCipher {
    private boolean _keyIs128;
    private static final int BLOCK_SIZE = 16;
    private static final long MASK8 = 255L;
    private static final long MASK32 = 0xFFFFFFFFL;
    private static final long SIGMA1 = -6872943284670656373L;
    private static final long SIGMA2 = -5297666545706961998L;
    private static final long SIGMA3 = -4112007255848680770L;
    private static final long SIGMA4 = 6124705990439038748L;
    private static final long SIGMA5 = 1217423232700263709L;
    private static final long SIGMA6 = -5740250305213840899L;
    private long _kw1;
    private long _kw2;
    private long _kw3;
    private long _kw4;
    private long _k1;
    private long _k2;
    private long _k3;
    private long _k4;
    private long _k5;
    private long _k6;
    private long _k7;
    private long _k8;
    private long _k9;
    private long _k10;
    private long _k11;
    private long _k12;
    private long _k13;
    private long _k14;
    private long _k15;
    private long _k16;
    private long _k17;
    private long _k18;
    private long _k19;
    private long _k20;
    private long _k21;
    private long _k22;
    private long _k23;
    private long _k24;
    private long _ke1;
    private long _ke2;
    private long _ke3;
    private long _ke4;
    private long _ke5;
    private long _ke6;
    private final byte[] SBOX1 = new byte[]{112, -126, 44, -20, -77, 39, -64, -27, -28, -123, 87, 53, -22, 12, -82, 65, 35, -17, 107, -109, 69, 25, -91, 33, -19, 14, 79, 78, 29, 101, -110, -67, -122, -72, -81, -113, 124, -21, 31, -50, 62, 48, -36, 95, 94, -59, 11, 26, -90, -31, 57, -54, -43, 71, 93, 61, -39, 1, 90, -42, 81, 86, 108, 77, -117, 13, -102, 102, -5, -52, -80, 45, 116, 18, 43, 32, -16, -79, -124, -103, -33, 76, -53, -62, 52, 126, 118, 5, 109, -73, -87, 49, -47, 23, 4, -41, 20, 88, 58, 97, -34, 27, 17, 28, 50, 15, -100, 22, 83, 24, -14, 34, -2, 68, -49, -78, -61, -75, 122, -111, 36, 8, -24, -88, 96, -4, 105, 80, -86, -48, -96, 125, -95, -119, 98, -105, 84, 91, 30, -107, -32, -1, 100, -46, 16, -60, 0, 72, -93, -9, 117, -37, -118, 3, -26, -38, 9, 63, -35, -108, -121, 92, -125, 2, -51, 74, -112, 51, 115, 103, -10, -13, -99, 127, -65, -30, 82, -101, -40, 38, -56, 55, -58, 59, -127, -106, 111, 75, 19, -66, 99, 46, -23, 121, -89, -116, -97, 110, -68, -114, 41, -11, -7, -74, 47, -3, -76, 89, 120, -104, 6, 106, -25, 70, 113, -70, -44, 37, -85, 66, -120, -94, -115, -6, 114, 7, -71, 85, -8, -18, -84, 10, 54, 73, 42, 104, 60, 56, -15, -92, 64, 40, -45, 123, -69, -55, 67, -63, 21, -29, -83, -12, 119, -57, -128, -98};
    private final byte[] SBOX2 = new byte[256];
    private final byte[] SBOX3 = new byte[256];
    private final byte[] SBOX4 = new byte[256];

    public CamelliaEngine() {
        for (int x = 0; x != 256; ++x) {
            this.SBOX2[x] = this.lRot8(this.SBOX1[x], 1);
            this.SBOX3[x] = this.lRot8(this.SBOX1[x], 7);
            this.SBOX4[x] = this.SBOX1[this.lRot8((byte)x, 1) & 0xFF];
        }
    }

    private void setKey(boolean forEncryption, byte[] key) {
        long krB;
        long krA;
        long klB;
        long klA;
        switch (key.length) {
            case 16: {
                this._keyIs128 = true;
                klA = this.bytesToWord(key, 0);
                klB = this.bytesToWord(key, 8);
                krA = 0L;
                krB = 0L;
                break;
            }
            case 24: {
                klA = this.bytesToWord(key, 0);
                klB = this.bytesToWord(key, 8);
                krA = this.bytesToWord(key, 16);
                krB = this.bytesToWord(key, 16) ^ 0xFFFFFFFFFFFFFFFFL;
                this._keyIs128 = false;
                break;
            }
            case 32: {
                klA = this.bytesToWord(key, 0);
                klB = this.bytesToWord(key, 8);
                krA = this.bytesToWord(key, 16);
                krB = this.bytesToWord(key, 24);
                this._keyIs128 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("only a key sizes of 128/192/256 are acceptable.");
            }
        }
        long d1 = klA ^ krA;
        long d2 = klB ^ krB;
        d2 ^= this.f(d1, -6872943284670656373L);
        d1 ^= this.f(d2, -5297666545706961998L);
        d2 ^= klB;
        d2 ^= this.f(d1 ^= klA, -4112007255848680770L);
        long kaA = d1 ^= this.f(d2, 6124705990439038748L);
        long kaB = d2;
        if (this._keyIs128) {
            if (forEncryption) {
                this._kw1 = klA;
                this._kw2 = klB;
                this._kw3 = this.lRot128high(kaA, kaB, 111);
                this._kw4 = this.lRot128low(kaA, kaB, 111);
                this._k1 = kaA;
                this._k2 = kaB;
                this._k3 = this.lRot128high(klA, klB, 15);
                this._k4 = this.lRot128low(klA, klB, 15);
                this._k5 = this.lRot128high(kaA, kaB, 15);
                this._k6 = this.lRot128low(kaA, kaB, 15);
                this._k7 = this.lRot128high(klA, klB, 45);
                this._k8 = this.lRot128low(klA, klB, 45);
                this._k9 = this.lRot128high(kaA, kaB, 45);
                this._k10 = this.lRot128low(klA, klB, 60);
                this._k11 = this.lRot128high(kaA, kaB, 60);
                this._k12 = this.lRot128low(kaA, kaB, 60);
                this._k13 = this.lRot128high(klA, klB, 94);
                this._k14 = this.lRot128low(klA, klB, 94);
                this._k15 = this.lRot128high(kaA, kaB, 94);
                this._k16 = this.lRot128low(kaA, kaB, 94);
                this._k17 = this.lRot128high(klA, klB, 111);
                this._k18 = this.lRot128low(klA, klB, 111);
                this._ke1 = this.lRot128high(kaA, kaB, 30);
                this._ke2 = this.lRot128low(kaA, kaB, 30);
                this._ke3 = this.lRot128high(klA, klB, 77);
                this._ke4 = this.lRot128low(klA, klB, 77);
            } else {
                this._kw3 = klA;
                this._kw4 = klB;
                this._kw1 = this.lRot128high(kaA, kaB, 111);
                this._kw2 = this.lRot128low(kaA, kaB, 111);
                this._k18 = kaA;
                this._k17 = kaB;
                this._k16 = this.lRot128high(klA, klB, 15);
                this._k15 = this.lRot128low(klA, klB, 15);
                this._k14 = this.lRot128high(kaA, kaB, 15);
                this._k13 = this.lRot128low(kaA, kaB, 15);
                this._k12 = this.lRot128high(klA, klB, 45);
                this._k11 = this.lRot128low(klA, klB, 45);
                this._k10 = this.lRot128high(kaA, kaB, 45);
                this._k9 = this.lRot128low(klA, klB, 60);
                this._k8 = this.lRot128high(kaA, kaB, 60);
                this._k7 = this.lRot128low(kaA, kaB, 60);
                this._k6 = this.lRot128high(klA, klB, 94);
                this._k5 = this.lRot128low(klA, klB, 94);
                this._k4 = this.lRot128high(kaA, kaB, 94);
                this._k3 = this.lRot128low(kaA, kaB, 94);
                this._k2 = this.lRot128high(klA, klB, 111);
                this._k1 = this.lRot128low(klA, klB, 111);
                this._ke4 = this.lRot128high(kaA, kaB, 30);
                this._ke3 = this.lRot128low(kaA, kaB, 30);
                this._ke2 = this.lRot128high(klA, klB, 77);
                this._ke1 = this.lRot128low(klA, klB, 77);
            }
        } else {
            d1 = kaA ^ krA;
            d2 = kaB ^ krB;
            d2 ^= this.f(d1, 1217423232700263709L);
            long kbA = d1 ^= this.f(d2, -5740250305213840899L);
            long kbB = d2;
            if (forEncryption) {
                this._kw1 = klA;
                this._kw2 = klB;
                this._k1 = kbA;
                this._k2 = kbB;
                this._k3 = this.lRot128high(krA, krB, 15);
                this._k4 = this.lRot128low(krA, krB, 15);
                this._k5 = this.lRot128high(kaA, kaB, 15);
                this._k6 = this.lRot128low(kaA, kaB, 15);
                this._ke1 = this.lRot128high(krA, krB, 30);
                this._ke2 = this.lRot128low(krA, krB, 30);
                this._k7 = this.lRot128high(kbA, kbB, 30);
                this._k8 = this.lRot128low(kbA, kbB, 30);
                this._k9 = this.lRot128high(klA, klB, 45);
                this._k10 = this.lRot128low(klA, klB, 45);
                this._k11 = this.lRot128high(kaA, kaB, 45);
                this._k12 = this.lRot128low(kaA, kaB, 45);
                this._ke3 = this.lRot128high(klA, klB, 60);
                this._ke4 = this.lRot128low(klA, klB, 60);
                this._k13 = this.lRot128high(krA, krB, 60);
                this._k14 = this.lRot128low(krA, krB, 60);
                this._k15 = this.lRot128high(kbA, kbB, 60);
                this._k16 = this.lRot128low(kbA, kbB, 60);
                this._k17 = this.lRot128high(klA, klB, 77);
                this._k18 = this.lRot128low(klA, klB, 77);
                this._ke5 = this.lRot128high(kaA, kaB, 77);
                this._ke6 = this.lRot128low(kaA, kaB, 77);
                this._k19 = this.lRot128high(krA, krB, 94);
                this._k20 = this.lRot128low(krA, krB, 94);
                this._k21 = this.lRot128high(kaA, kaB, 94);
                this._k22 = this.lRot128low(kaA, kaB, 94);
                this._k23 = this.lRot128high(klA, klB, 111);
                this._k24 = this.lRot128low(klA, klB, 111);
                this._kw3 = this.lRot128high(kbA, kbB, 111);
                this._kw4 = this.lRot128low(kbA, kbB, 111);
            } else {
                this._kw3 = klA;
                this._kw4 = klB;
                this._kw1 = this.lRot128high(kbA, kbB, 111);
                this._kw2 = this.lRot128low(kbA, kbB, 111);
                this._k24 = kbA;
                this._k23 = kbB;
                this._k22 = this.lRot128high(krA, krB, 15);
                this._k21 = this.lRot128low(krA, krB, 15);
                this._k20 = this.lRot128high(kaA, kaB, 15);
                this._k19 = this.lRot128low(kaA, kaB, 15);
                this._k18 = this.lRot128high(kbA, kbB, 30);
                this._k17 = this.lRot128low(kbA, kbB, 30);
                this._k16 = this.lRot128high(klA, klB, 45);
                this._k15 = this.lRot128low(klA, klB, 45);
                this._k14 = this.lRot128high(kaA, kaB, 45);
                this._k13 = this.lRot128low(kaA, kaB, 45);
                this._k12 = this.lRot128high(krA, krB, 60);
                this._k11 = this.lRot128low(krA, krB, 60);
                this._k10 = this.lRot128high(kbA, kbB, 60);
                this._k9 = this.lRot128low(kbA, kbB, 60);
                this._k8 = this.lRot128high(klA, klB, 77);
                this._k7 = this.lRot128low(klA, klB, 77);
                this._k6 = this.lRot128high(krA, krB, 94);
                this._k5 = this.lRot128low(krA, krB, 94);
                this._k4 = this.lRot128high(kaA, kaB, 94);
                this._k3 = this.lRot128low(kaA, kaB, 94);
                this._k2 = this.lRot128high(klA, klB, 111);
                this._k1 = this.lRot128low(klA, klB, 111);
                this._ke6 = this.lRot128high(krA, krB, 30);
                this._ke5 = this.lRot128low(krA, krB, 30);
                this._ke4 = this.lRot128high(klA, klB, 60);
                this._ke3 = this.lRot128low(klA, klB, 60);
                this._ke2 = this.lRot128high(kaA, kaB, 77);
                this._ke1 = this.lRot128low(kaA, kaB, 77);
            }
        }
    }

    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("only simple KeyParameter expected.");
        }
        this.setKey(forEncryption, ((KeyParameter)params).getKey());
    }

    public String getAlgorithmName() {
        return "Camellia";
    }

    public int getBlockSize() {
        return 16;
    }

    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this._keyIs128) {
            return this.processBlock128(in, inOff, out, outOff);
        }
        return this.processBlock192or256(in, inOff, out, outOff);
    }

    public void reset() {
    }

    private byte lRot8(byte value, int rotation) {
        return (byte)(value << rotation | (value & 0xFF) >>> 8 - rotation);
    }

    private int lRot32(int value, int rotation) {
        return value << rotation | value >>> 32 - rotation;
    }

    private long lRot128high(long a, long b, int rotation) {
        a = rotation < 64 ? a << rotation | b >>> 64 - rotation : (rotation == 64 ? b : b << rotation - 64 | a >>> 64 - (rotation - 64));
        return a;
    }

    private long lRot128low(long a, long b, int rotation) {
        b = rotation < 64 ? b << rotation | a >>> 64 - rotation : (rotation == 64 ? a : a << rotation - 64 | b >>> 64 - (rotation - 64));
        return b;
    }

    private long fl(long in, long ke) {
        int x1 = (int)(in >> 32);
        int x2 = (int)in;
        int k1 = (int)(ke >> 32);
        int k2 = (int)ke;
        x2 ^= this.lRot32(x1 & k1, 1);
        return (long)(x1 ^= x2 | k2) << 32 | (long)x2 & 0xFFFFFFFFL;
    }

    private long flInv(long in, long ke) {
        int y1 = (int)(in >> 32);
        int y2 = (int)in;
        int k1 = (int)(ke >> 32);
        int k2 = (int)ke;
        y1 ^= y2 | k2;
        return (long)y1 << 32 | (long)(y2 ^= this.lRot32(y1 & k1, 1)) & 0xFFFFFFFFL;
    }

    private long f(long in, long ke) {
        long x = in ^ ke;
        int a = (int)(x >> 32);
        int b = (int)x;
        byte t1 = this.SBOX1[a >> 24 & 0xFF];
        byte t2 = this.SBOX2[a >> 16 & 0xFF];
        byte t3 = this.SBOX3[a >> 8 & 0xFF];
        byte t4 = this.SBOX4[a & 0xFF];
        byte t5 = this.SBOX2[b >> 24 & 0xFF];
        byte t6 = this.SBOX3[b >> 16 & 0xFF];
        byte t7 = this.SBOX4[b >> 8 & 0xFF];
        byte t8 = this.SBOX1[b & 0xFF];
        int y1 = t1 ^ t3 ^ t4 ^ t6 ^ t7 ^ t8;
        int y2 = t1 ^ t2 ^ t4 ^ t5 ^ t7 ^ t8;
        int y3 = t1 ^ t2 ^ t3 ^ t5 ^ t6 ^ t8;
        int y4 = t2 ^ t3 ^ t4 ^ t5 ^ t6 ^ t7;
        int y5 = t1 ^ t2 ^ t6 ^ t7 ^ t8;
        int y6 = t2 ^ t3 ^ t5 ^ t7 ^ t8;
        int y7 = t3 ^ t4 ^ t5 ^ t6 ^ t8;
        int y8 = t1 ^ t4 ^ t5 ^ t6 ^ t7;
        return (long)y1 << 56 | ((long)y2 & 0xFFL) << 48 | ((long)y3 & 0xFFL) << 40 | ((long)y4 & 0xFFL) << 32 | ((long)y5 & 0xFFL) << 24 | ((long)y6 & 0xFFL) << 16 | ((long)y7 & 0xFFL) << 8 | (long)y8 & 0xFFL;
    }

    private long bytesToWord(byte[] src, int srcOff) {
        long word = 0L;
        for (int i = 0; i < 8; ++i) {
            word = (word << 8) + (long)(src[i + srcOff] & 0xFF);
        }
        return word;
    }

    private void wordToBytes(long word, byte[] dst, int dstOff) {
        for (int i = 0; i < 8; ++i) {
            dst[7 - i + dstOff] = (byte)word;
            word >>>= 8;
        }
    }

    private int processBlock128(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long d1 = this.bytesToWord(in, inOff);
        long d2 = this.bytesToWord(in, inOff + 8);
        d2 ^= this._kw2;
        d2 ^= this.f(d1 ^= this._kw1, this._k1);
        d1 ^= this.f(d2, this._k2);
        d2 ^= this.f(d1, this._k3);
        d1 ^= this.f(d2, this._k4);
        d2 ^= this.f(d1, this._k5);
        d1 ^= this.f(d2, this._k6);
        d1 = this.fl(d1, this._ke1);
        d2 = this.flInv(d2, this._ke2);
        d2 ^= this.f(d1, this._k7);
        d1 ^= this.f(d2, this._k8);
        d2 ^= this.f(d1, this._k9);
        d1 ^= this.f(d2, this._k10);
        d2 ^= this.f(d1, this._k11);
        d1 ^= this.f(d2, this._k12);
        d1 = this.fl(d1, this._ke3);
        d2 = this.flInv(d2, this._ke4);
        d2 ^= this.f(d1, this._k13);
        d1 ^= this.f(d2, this._k14);
        d2 ^= this.f(d1, this._k15);
        d1 ^= this.f(d2, this._k16);
        d2 ^= this.f(d1, this._k17);
        d1 ^= this.f(d2, this._k18);
        this.wordToBytes(d2 ^= this._kw3, out, outOff);
        this.wordToBytes(d1 ^= this._kw4, out, outOff + 8);
        return 16;
    }

    private int processBlock192or256(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        long d1 = this.bytesToWord(in, inOff);
        long d2 = this.bytesToWord(in, inOff + 8);
        d2 ^= this._kw2;
        d2 ^= this.f(d1 ^= this._kw1, this._k1);
        d1 ^= this.f(d2, this._k2);
        d2 ^= this.f(d1, this._k3);
        d1 ^= this.f(d2, this._k4);
        d2 ^= this.f(d1, this._k5);
        d1 ^= this.f(d2, this._k6);
        d1 = this.fl(d1, this._ke1);
        d2 = this.flInv(d2, this._ke2);
        d2 ^= this.f(d1, this._k7);
        d1 ^= this.f(d2, this._k8);
        d2 ^= this.f(d1, this._k9);
        d1 ^= this.f(d2, this._k10);
        d2 ^= this.f(d1, this._k11);
        d1 ^= this.f(d2, this._k12);
        d1 = this.fl(d1, this._ke3);
        d2 = this.flInv(d2, this._ke4);
        d2 ^= this.f(d1, this._k13);
        d1 ^= this.f(d2, this._k14);
        d2 ^= this.f(d1, this._k15);
        d1 ^= this.f(d2, this._k16);
        d2 ^= this.f(d1, this._k17);
        d1 ^= this.f(d2, this._k18);
        d1 = this.fl(d1, this._ke5);
        d2 = this.flInv(d2, this._ke6);
        d2 ^= this.f(d1, this._k19);
        d1 ^= this.f(d2, this._k20);
        d2 ^= this.f(d1, this._k21);
        d1 ^= this.f(d2, this._k22);
        d2 ^= this.f(d1, this._k23);
        d1 ^= this.f(d2, this._k24);
        this.wordToBytes(d2 ^= this._kw3, out, outOff);
        this.wordToBytes(d1 ^= this._kw4, out, outOff + 8);
        return 16;
    }
}

