/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.attr;

import org.bouncycastle.bcpg.UserAttributeSubpacket;

public class ImageAttribute
extends UserAttributeSubpacket {
    private int hdrLength;
    private int version;
    private int encoding;
    private byte[] imageData;

    public ImageAttribute(byte[] data) {
        super(1, data);
        this.hdrLength = (data[1] & 0xFF) << 8 | data[0] & 0xFF;
        this.version = data[2] & 0xFF;
        this.encoding = data[3] & 0xFF;
        this.imageData = new byte[data.length - this.hdrLength];
        System.arraycopy(data, this.hdrLength, this.imageData, 0, this.imageData.length);
    }

    public int version() {
        return this.version;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public byte[] getImageData() {
        return this.imageData;
    }
}

