/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketTags;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    InputStream in;

    public SignatureSubpacketInputStream(InputStream in) {
        this.in = in;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    private void readFully(byte[] buf, int off, int len) throws IOException {
        if (len > 0) {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            buf[off] = (byte)b;
            ++off;
            --len;
        }
        while (len > 0) {
            int l = this.in.read(buf, off, len);
            if (l < 0) {
                throw new EOFException();
            }
            off += l;
            len -= l;
        }
    }

    public SignatureSubpacket readPacket() throws IOException {
        int l = this.read();
        int bodyLen = 0;
        if (l < 0) {
            return null;
        }
        if (l < 192) {
            bodyLen = l;
        } else if (l < 223) {
            bodyLen = (l - 192 << 8) + this.in.read() + 192;
        } else if (l == 255) {
            bodyLen = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        }
        int tag = this.in.read();
        if (tag < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        byte[] data = new byte[bodyLen - 1];
        this.readFully(data, 0, data.length);
        boolean isCritical = (tag & 0x80) != 0;
        int type = tag & 0x7F;
        switch (type) {
            case 2: {
                return new SignatureCreationTime(isCritical, data);
            }
            case 9: {
                return new KeyExpirationTime(isCritical, data);
            }
            case 3: {
                return new SignatureExpirationTime(isCritical, data);
            }
            case 7: {
                return new Revocable(isCritical, data);
            }
            case 4: {
                return new Exportable(isCritical, data);
            }
            case 16: {
                return new IssuerKeyID(isCritical, data);
            }
            case 5: {
                return new TrustSignature(isCritical, data);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(type, isCritical, data);
            }
            case 27: {
                return new KeyFlags(isCritical, data);
            }
            case 25: {
                return new PrimaryUserID(isCritical, data);
            }
            case 28: {
                return new SignerUserID(isCritical, data);
            }
        }
        return new SignatureSubpacket(type, isCritical, data);
    }
}

