/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;

public class SecretKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private PublicKeyPacket pubKeyPacket;
    private byte[] secKeyData;
    private int stringToKey;
    private int encAlgorithm;
    private S2K s2k;
    private byte[] iv;

    SecretKeyPacket(BCPGInputStream in) throws IOException {
        this.pubKeyPacket = new PublicKeyPacket(in);
        this.stringToKey = in.read();
        if (this.stringToKey == 255 || this.stringToKey == 254) {
            this.encAlgorithm = in.read();
            this.s2k = new S2K(in);
        } else {
            this.encAlgorithm = this.stringToKey;
        }
        if ((this.s2k == null || this.s2k.getType() != 101 || this.s2k.getProtectionMode() != 1) && this.stringToKey != 0) {
            this.iv = this.encAlgorithm < 7 ? new byte[8] : new byte[16];
            in.readFully(this.iv, 0, this.iv.length);
        }
        if (in.available() != 0) {
            int b;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(in.available());
            while ((b = in.read()) >= 0) {
                bOut.write(b);
            }
            this.secKeyData = bOut.toByteArray();
        }
    }

    public SecretKeyPacket(PublicKeyPacket pubKeyPacket, int encAlgorithm, S2K s2k, byte[] iv, byte[] secKeyData) {
        this.pubKeyPacket = pubKeyPacket;
        this.encAlgorithm = encAlgorithm;
        this.stringToKey = encAlgorithm != 0 ? 255 : 0;
        this.s2k = s2k;
        this.iv = iv;
        this.secKeyData = secKeyData;
    }

    public int getEncAlgorithm() {
        return this.encAlgorithm;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public S2K getS2K() {
        return this.s2k;
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.pubKeyPacket;
    }

    public byte[] getSecretKeyData() {
        return this.secKeyData;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.pubKeyPacket.getEncodedContents());
        pOut.write(this.stringToKey);
        if (this.stringToKey == 255 || this.stringToKey == 254) {
            pOut.write(this.encAlgorithm);
            pOut.writeObject(this.s2k);
        }
        if (this.iv != null) {
            pOut.write(this.iv);
        }
        if (this.secKeyData != null) {
            pOut.write(this.secKeyData);
        }
        return bOut.toByteArray();
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(5, this.getEncodedContents(), true);
    }
}

