/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;

public class DSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger p;
    MPInteger q;
    MPInteger g;
    MPInteger y;

    public DSAPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.p = new MPInteger(in);
        this.q = new MPInteger(in);
        this.g = new MPInteger(in);
        this.y = new MPInteger(in);
    }

    public DSAPublicBCPGKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        this.p = new MPInteger(p);
        this.q = new MPInteger(q);
        this.g = new MPInteger(g);
        this.y = new MPInteger(y);
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            BCPGOutputStream pgpOut = new BCPGOutputStream(bOut);
            pgpOut.writeObject(this);
            return bOut.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.p);
        out.writeObject(this.q);
        out.writeObject(this.g);
        out.writeObject(this.y);
    }

    public BigInteger getG() {
        return this.g.getValue();
    }

    public BigInteger getP() {
        return this.p.getValue();
    }

    public BigInteger getQ() {
        return this.q.getValue();
    }

    public BigInteger getY() {
        return this.y.getValue();
    }
}

