/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.math.ec.ECFieldElement;

public class X9FieldElement
extends ASN1Encodable {
    private ECFieldElement f;

    public X9FieldElement(ECFieldElement f) {
        this.f = f;
    }

    public X9FieldElement(boolean fP, BigInteger q, ASN1OctetString s) {
        if (!fP) {
            throw new RuntimeException("not implemented");
        }
        this.f = new ECFieldElement.Fp(q, new BigInteger(1, s.getOctets()));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    public DERObject toASN1Object() {
        return new DEROctetString(this.f.toBigInteger().toByteArray());
    }
}

