/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.ObjectDigestInfo;

public class Holder
extends ASN1Encodable {
    IssuerSerial baseCertificateID;
    GeneralNames entityName;
    ObjectDigestInfo objectDigestInfo;

    public static Holder getInstance(Object obj) {
        if (obj instanceof Holder) {
            return (Holder)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new Holder((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public Holder(ASN1Sequence seq) {
        block5: for (int i = 0; i != seq.size(); ++i) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (tObj.getTagNo()) {
                case 0: {
                    this.baseCertificateID = IssuerSerial.getInstance(tObj, false);
                    continue block5;
                }
                case 1: {
                    this.entityName = GeneralNames.getInstance(tObj, false);
                    continue block5;
                }
                case 2: {
                    this.objectDigestInfo = ObjectDigestInfo.getInstance(tObj, false);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag in Holder");
                }
            }
        }
    }

    public Holder(IssuerSerial baseCertificateID) {
        this.baseCertificateID = baseCertificateID;
    }

    public Holder(GeneralNames entityName) {
        this.entityName = entityName;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.baseCertificateID;
    }

    public GeneralNames getEntityName() {
        return this.entityName;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.baseCertificateID != null) {
            v.add(new DERTaggedObject(false, 0, this.baseCertificateID));
        }
        if (this.entityName != null) {
            v.add(new DERTaggedObject(false, 1, this.entityName));
        }
        if (this.objectDigestInfo != null) {
            v.add(new DERTaggedObject(false, 2, this.objectDigestInfo));
        }
        return new DERSequence(v);
    }
}

