/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;

public class AttributeTable {
    private Hashtable attributes = new Hashtable();

    public AttributeTable(Hashtable attrs) {
        this.attributes = new Hashtable(attrs);
    }

    public AttributeTable(DEREncodableVector v) {
        for (int i = 0; i != v.size(); ++i) {
            Attribute a = Attribute.getInstance(v.get(i));
            this.attributes.put(a.getAttrType(), a);
        }
    }

    public AttributeTable(ASN1Set s) {
        for (int i = 0; i != s.size(); ++i) {
            Attribute a = Attribute.getInstance(s.getObjectAt(i));
            this.attributes.put(a.getAttrType(), a);
        }
    }

    public Attribute get(DERObjectIdentifier oid) {
        return (Attribute)this.attributes.get(oid);
    }

    public Hashtable toHashtable() {
        return new Hashtable(this.attributes);
    }
}

