/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;

public class UserKeyingMaterial
implements DEREncodable {
    private DEROctetString material;

    public UserKeyingMaterial(byte[] byArray) {
        this.setMaterial(byArray);
    }

    public UserKeyingMaterial(DEROctetString dEROctetString) {
        this.material = dEROctetString;
    }

    public UserKeyingMaterial(UserKeyingMaterial userKeyingMaterial) {
        this.material = userKeyingMaterial.material;
    }

    public static UserKeyingMaterial getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof UserKeyingMaterial) {
            return (UserKeyingMaterial)object;
        }
        if (object instanceof DEROctetString) {
            return new UserKeyingMaterial((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return UserKeyingMaterial.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid UserKeyingMaterial");
    }

    public static UserKeyingMaterial newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof UserKeyingMaterial) {
            return new UserKeyingMaterial((UserKeyingMaterial)object);
        }
        if (object instanceof DEROctetString) {
            return new UserKeyingMaterial((DEROctetString)object);
        }
        if (object instanceof BERTaggedObject) {
            return UserKeyingMaterial.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid UserKeyingMaterial");
    }

    public byte[] getMaterial() {
        return this.material.getOctets();
    }

    private void setMaterial(byte[] byArray) {
        this.material = new DEROctetString(byArray);
    }

    public DERObject getDERObject() {
        return this.material;
    }
}

