/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.CertificateRevocationLists;
import org.bouncycastle.asn1.cms.CertificateSet;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifiers;
import org.bouncycastle.asn1.cms.EncapsulatedContentInfo;
import org.bouncycastle.asn1.cms.SignerInfos;

public class SignedData
implements DEREncodable {
    private CMSVersion version;
    private DigestAlgorithmIdentifiers digestAlgorithms;
    private EncapsulatedContentInfo encapContentInfo;
    private CertificateSet certificates;
    private CertificateRevocationLists crls;
    private SignerInfos signerInfos;

    public SignedData(CMSVersion cMSVersion, DigestAlgorithmIdentifiers digestAlgorithmIdentifiers, EncapsulatedContentInfo encapsulatedContentInfo, CertificateSet certificateSet, CertificateRevocationLists certificateRevocationLists, SignerInfos signerInfos) {
        this.setVersion(cMSVersion);
        this.setDigestAlgorithms(digestAlgorithmIdentifiers);
        this.setEncapContentInfo(encapsulatedContentInfo);
        this.setCertificates(certificateSet);
        this.setCrls(certificateRevocationLists);
        this.setSignerInfos(signerInfos);
    }

    public SignedData(BERConstructedSequence bERConstructedSequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(n++));
        this.digestAlgorithms = DigestAlgorithmIdentifiers.getInstance(bERConstructedSequence.getObjectAt(n++));
        this.encapContentInfo = EncapsulatedContentInfo.getInstance(bERConstructedSequence.getObjectAt(n++));
        block0 : switch (bERConstructedSequence.getSize()) {
            case 4: {
                break;
            }
            case 5: {
                BERTaggedObject bERTaggedObject = (BERTaggedObject)bERConstructedSequence.getObjectAt(n++);
                switch (bERTaggedObject.getTagNo()) {
                    case 0: {
                        this.certificates = CertificateSet.getInstance(bERTaggedObject);
                        break block0;
                    }
                    case 1: {
                        this.crls = CertificateRevocationLists.getInstance(bERTaggedObject);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid SignedData");
            }
            case 6: {
                this.certificates = CertificateSet.getInstance(bERConstructedSequence.getObjectAt(n++));
                this.crls = CertificateRevocationLists.getInstance(bERConstructedSequence.getObjectAt(n++));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid SignedData");
            }
        }
        this.signerInfos = SignerInfos.getInstance(bERConstructedSequence.getObjectAt(n));
    }

    public SignedData(SignedData signedData) {
        this.version = signedData.version;
        this.digestAlgorithms = signedData.digestAlgorithms;
        this.encapContentInfo = signedData.encapContentInfo;
        this.certificates = signedData.certificates;
        this.crls = signedData.crls;
        this.signerInfos = signedData.signerInfos;
    }

    public static SignedData getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignedData) {
            return (SignedData)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new SignedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignedData");
    }

    public static SignedData newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignedData) {
            return new SignedData((SignedData)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new SignedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignedData");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public DigestAlgorithmIdentifiers getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    private void setDigestAlgorithms(DigestAlgorithmIdentifiers digestAlgorithmIdentifiers) {
        this.digestAlgorithms = digestAlgorithmIdentifiers;
    }

    public EncapsulatedContentInfo getEncapContentInfo() {
        return this.encapContentInfo;
    }

    private void setEncapContentInfo(EncapsulatedContentInfo encapsulatedContentInfo) {
        this.encapContentInfo = encapsulatedContentInfo;
    }

    public CertificateSet getCertificates() {
        return this.certificates;
    }

    private void setCertificates(CertificateSet certificateSet) {
        this.certificates = certificateSet;
    }

    public CertificateRevocationLists getCrls() {
        return this.crls;
    }

    private void setCrls(CertificateRevocationLists certificateRevocationLists) {
        this.crls = certificateRevocationLists;
    }

    public SignerInfos getSignerInfos() {
        return this.signerInfos;
    }

    private void setSignerInfos(SignerInfos signerInfos) {
        this.signerInfos = signerInfos;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.digestAlgorithms);
        bERConstructedSequence.addObject(this.encapContentInfo);
        if (this.certificates != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.certificates.getDERObject()));
        }
        if (this.crls != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.crls.getDERObject()));
        }
        bERConstructedSequence.addObject(this.signerInfos);
        return bERConstructedSequence;
    }
}

