/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SignatureAlgorithmIdentifier
implements DEREncodable {
    private AlgorithmIdentifier alg;

    public SignatureAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public SignatureAlgorithmIdentifier(BERConstructedSequence bERConstructedSequence) {
        this.alg = new AlgorithmIdentifier(bERConstructedSequence);
    }

    public SignatureAlgorithmIdentifier(SignatureAlgorithmIdentifier signatureAlgorithmIdentifier) {
        this.alg = signatureAlgorithmIdentifier.alg;
    }

    public SignatureAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public SignatureAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static SignatureAlgorithmIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignatureAlgorithmIdentifier) {
            return (SignatureAlgorithmIdentifier)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new SignatureAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new SignatureAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignatureAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignatureAlgorithmIdentifier");
    }

    public static SignatureAlgorithmIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SignatureAlgorithmIdentifier) {
            return new SignatureAlgorithmIdentifier((SignatureAlgorithmIdentifier)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new SignatureAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new SignatureAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return SignatureAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid SignatureAlgorithmIdentifier");
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }
}

