/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.math.BigInteger;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class RC2ParameterVersion
implements DEREncodable {
    private DERInteger version;

    public RC2ParameterVersion(BigInteger bigInteger) {
        this.setVersion(bigInteger);
    }

    public RC2ParameterVersion(DERInteger dERInteger) {
        this.version = dERInteger;
    }

    public RC2ParameterVersion(RC2ParameterVersion rC2ParameterVersion) {
        this.version = rC2ParameterVersion.version;
    }

    public static RC2ParameterVersion getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RC2ParameterVersion) {
            return (RC2ParameterVersion)object;
        }
        if (object instanceof DERInteger) {
            return new RC2ParameterVersion((DERInteger)object);
        }
        if (object instanceof BERTaggedObject) {
            return RC2ParameterVersion.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RC2ParameterVersion");
    }

    public static RC2ParameterVersion newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RC2ParameterVersion) {
            return new RC2ParameterVersion((RC2ParameterVersion)object);
        }
        if (object instanceof DERInteger) {
            return new RC2ParameterVersion((DERInteger)object);
        }
        if (object instanceof BERTaggedObject) {
            return RC2ParameterVersion.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RC2ParameterVersion");
    }

    public BigInteger getVersion() {
        return this.version.getValue();
    }

    private void setVersion(BigInteger bigInteger) {
        this.version = new DERInteger(bigInteger);
    }

    public DERObject getDERObject() {
        return this.version;
    }
}

