/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;

public class OtherKeyAttribute
implements DEREncodable {
    private DERObjectIdentifier keyAttrId;
    private DERObject keyAttr;

    public OtherKeyAttribute(String string, DERObject dERObject) {
        this.setKeyAttributeId(string);
        this.setKeyAttribute(dERObject);
    }

    public OtherKeyAttribute(BERConstructedSequence bERConstructedSequence) {
        this.keyAttrId = (DERObjectIdentifier)bERConstructedSequence.getObjectAt(0);
        if (bERConstructedSequence.getSize() > 1) {
            this.keyAttr = (DERObject)bERConstructedSequence.getObjectAt(1);
        }
    }

    public OtherKeyAttribute(OtherKeyAttribute otherKeyAttribute) {
        this.keyAttrId = otherKeyAttribute.keyAttrId;
        this.keyAttr = otherKeyAttribute.keyAttr;
    }

    public static OtherKeyAttribute getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OtherKeyAttribute) {
            return (OtherKeyAttribute)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new OtherKeyAttribute((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return OtherKeyAttribute.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OtherKeyAttribute");
    }

    public static OtherKeyAttribute newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OtherKeyAttribute) {
            return new OtherKeyAttribute((OtherKeyAttribute)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new OtherKeyAttribute((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return OtherKeyAttribute.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OtherKeyAttribute");
    }

    public String getKeyAttributeId() {
        return this.keyAttrId.getId();
    }

    private void setKeyAttributeId(String string) {
        this.keyAttrId = new DERObjectIdentifier(string);
    }

    public DERObject getKeyAttribute() {
        return this.keyAttr;
    }

    private void setKeyAttribute(DERObject dERObject) {
        this.keyAttr = dERObject;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.keyAttrId);
        if (this.keyAttr != null) {
            bERConstructedSequence.addObject(this.keyAttr);
        }
        return bERConstructedSequence;
    }
}

