/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedKey;
import org.bouncycastle.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.RecipientIdentifier;

public class KeyTransRecipientInfo
implements DEREncodable {
    private CMSVersion version;
    private RecipientIdentifier rid;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
    private EncryptedKey encryptedKey;

    public KeyTransRecipientInfo(CMSVersion cMSVersion, RecipientIdentifier recipientIdentifier, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, EncryptedKey encryptedKey) {
        this.setVersion(cMSVersion);
        this.setRecipientIdentifier(recipientIdentifier);
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier);
        this.setEncryptedKey(encryptedKey);
    }

    public KeyTransRecipientInfo(BERConstructedSequence bERConstructedSequence) {
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(0));
        this.rid = RecipientIdentifier.getInstance(bERConstructedSequence.getObjectAt(1));
        this.keyEncryptionAlgorithm = KeyEncryptionAlgorithmIdentifier.getInstance(bERConstructedSequence.getObjectAt(2));
        this.encryptedKey = EncryptedKey.getInstance(bERConstructedSequence.getObjectAt(3));
    }

    public KeyTransRecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.version = keyTransRecipientInfo.version;
        this.rid = keyTransRecipientInfo.rid;
        this.keyEncryptionAlgorithm = keyTransRecipientInfo.keyEncryptionAlgorithm;
        this.encryptedKey = keyTransRecipientInfo.encryptedKey;
    }

    public static KeyTransRecipientInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyTransRecipientInfo) {
            return (KeyTransRecipientInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyTransRecipientInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyTransRecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyTransRecipientInfo");
    }

    public static KeyTransRecipientInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyTransRecipientInfo) {
            return new KeyTransRecipientInfo((KeyTransRecipientInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyTransRecipientInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyTransRecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyTransRecipientInfo");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public RecipientIdentifier getRecipientIdentifier() {
        return this.rid;
    }

    private void setRecipientIdentifier(RecipientIdentifier recipientIdentifier) {
        this.rid = recipientIdentifier;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    private void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithmIdentifier;
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    private void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.rid);
        bERConstructedSequence.addObject(this.keyEncryptionAlgorithm);
        bERConstructedSequence.addObject(this.encryptedKey);
        return bERConstructedSequence;
    }
}

