/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyEncryptionAlgorithmIdentifier
implements DEREncodable {
    private AlgorithmIdentifier alg;

    public KeyEncryptionAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public KeyEncryptionAlgorithmIdentifier(BERConstructedSequence bERConstructedSequence) {
        this.alg = new AlgorithmIdentifier(bERConstructedSequence);
    }

    public KeyEncryptionAlgorithmIdentifier(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.alg = keyEncryptionAlgorithmIdentifier.alg;
    }

    public KeyEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public KeyEncryptionAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static KeyEncryptionAlgorithmIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyEncryptionAlgorithmIdentifier) {
            return (KeyEncryptionAlgorithmIdentifier)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyEncryptionAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new KeyEncryptionAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyEncryptionAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyEncryptionAlgorithmIdentifier");
    }

    public static KeyEncryptionAlgorithmIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyEncryptionAlgorithmIdentifier) {
            return new KeyEncryptionAlgorithmIdentifier((KeyEncryptionAlgorithmIdentifier)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new KeyEncryptionAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new KeyEncryptionAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyEncryptionAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyEncryptionAlgorithmIdentifier");
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }
}

