/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.ExtendedCertificateInfo;
import org.bouncycastle.asn1.cms.Signature;
import org.bouncycastle.asn1.cms.SignatureAlgorithmIdentifier;

public class ExtendedCertificate
implements DEREncodable {
    private ExtendedCertificateInfo extendedCertificateInfo;
    private SignatureAlgorithmIdentifier signatureAlgorithm;
    private Signature signature;

    public ExtendedCertificate(DERConstructedSequence dERConstructedSequence) {
        this.extendedCertificateInfo = ExtendedCertificateInfo.getInstance(dERConstructedSequence.getObjectAt(0));
        this.signatureAlgorithm = SignatureAlgorithmIdentifier.getInstance(dERConstructedSequence.getObjectAt(1));
        this.signature = Signature.getInstance(dERConstructedSequence.getObjectAt(2));
    }

    public static ExtendedCertificate getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedCertificate) {
            return (ExtendedCertificate)object;
        }
        if (object instanceof DERConstructedSequence) {
            return new ExtendedCertificate((DERConstructedSequence)object);
        }
        throw new IllegalArgumentException("Invalid ExtendedCertificate");
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.extendedCertificateInfo);
        dERConstructedSequence.addObject(this.signatureAlgorithm);
        dERConstructedSequence.addObject(this.signature);
        return dERConstructedSequence;
    }
}

