/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.ContentEncryptionAlgorithmIdentifier;
import org.bouncycastle.asn1.cms.ContentType;
import org.bouncycastle.asn1.cms.EncryptedContent;

public class EncryptedContentInfo
implements DEREncodable {
    private ContentType contentType;
    private ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithm;
    private EncryptedContent encryptedContent;

    public EncryptedContentInfo(ContentType contentType, ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier, EncryptedContent encryptedContent) {
        this.setContentType(contentType);
        this.setContentEncryptionAlgorithm(contentEncryptionAlgorithmIdentifier);
        this.setEncryptedContent(encryptedContent);
    }

    public EncryptedContentInfo(BERConstructedSequence bERConstructedSequence) {
        this.contentType = ContentType.getInstance(bERConstructedSequence.getObjectAt(0));
        this.contentEncryptionAlgorithm = ContentEncryptionAlgorithmIdentifier.getInstance(bERConstructedSequence.getObjectAt(1));
        if (bERConstructedSequence.getSize() > 2) {
            this.encryptedContent = EncryptedContent.getInstance(bERConstructedSequence.getObjectAt(2));
        }
    }

    public EncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.contentType = encryptedContentInfo.contentType;
        this.contentEncryptionAlgorithm = encryptedContentInfo.contentEncryptionAlgorithm;
        this.encryptedContent = encryptedContentInfo.encryptedContent;
    }

    public static EncryptedContentInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedContentInfo) {
            return (EncryptedContentInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new EncryptedContentInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedContentInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedContentInfo");
    }

    public static EncryptedContentInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EncryptedContentInfo) {
            return new EncryptedContentInfo((EncryptedContentInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new EncryptedContentInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EncryptedContentInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EncryptedContentInfo");
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    private void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public ContentEncryptionAlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    private void setContentEncryptionAlgorithm(ContentEncryptionAlgorithmIdentifier contentEncryptionAlgorithmIdentifier) {
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithmIdentifier;
    }

    public EncryptedContent getEncryptedContent() {
        return this.encryptedContent;
    }

    private void setEncryptedContent(EncryptedContent encryptedContent) {
        this.encryptedContent = encryptedContent;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.contentType);
        bERConstructedSequence.addObject(this.contentEncryptionAlgorithm);
        if (this.encryptedContent != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.encryptedContent.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

