/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;

public class RecipientIdentifier
implements DEREncodable {
    private DEREncodable id;

    public RecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    public RecipientIdentifier(ASN1OctetString aSN1OctetString) {
        this.id = new DERTaggedObject(false, 0, aSN1OctetString);
    }

    public RecipientIdentifier(DERObject dERObject) {
        this.id = dERObject;
    }

    public static RecipientIdentifier getInstance(Object object) {
        if (object == null || object instanceof RecipientIdentifier) {
            return (RecipientIdentifier)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new RecipientIdentifier((IssuerAndSerialNumber)object);
        }
        if (object instanceof ASN1OctetString) {
            return new RecipientIdentifier((ASN1OctetString)object);
        }
        if (object instanceof DERObject) {
            return new RecipientIdentifier((DERObject)object);
        }
        throw new IllegalArgumentException("Illegal object in RecipientIdentifier: " + object.getClass().getName());
    }

    public boolean isTagged() {
        return this.id instanceof ASN1TaggedObject;
    }

    public DEREncodable getId() {
        if (this.id instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance((ASN1TaggedObject)this.id, false);
        }
        return IssuerAndSerialNumber.getInstance(this.id);
    }

    public DERObject getDERObject() {
        return this.id.getDERObject();
    }
}

