/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class PasswordRecipientInformation
extends RecipientInformation {
    private PasswordRecipientInfo _info;
    private AlgorithmIdentifier _encAlg;

    public PasswordRecipientInformation(PasswordRecipientInfo passwordRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        super(algorithmIdentifier, AlgorithmIdentifier.getInstance((Object)passwordRecipientInfo.getKeyEncryptionAlgorithm()), inputStream);
        this._info = passwordRecipientInfo;
        this._encAlg = algorithmIdentifier;
        this._rid = new RecipientId();
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        try {
            AlgorithmIdentifier algorithmIdentifier = AlgorithmIdentifier.getInstance((Object)this._info.getKeyEncryptionAlgorithm());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)algorithmIdentifier.getParameters();
            byte[] byArray = this._info.getEncryptedKey().getOctets();
            String string2 = DERObjectIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(0)).getId();
            Cipher cipher = Cipher.getInstance(CMSEnvelopedHelper.INSTANCE.getRFC3211WrapperName(string2), string);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(1)).getOctets());
            cipher.init(4, (Key)new SecretKeySpec(((CMSPBEKey)key).getEncoded(string2), string2), ivParameterSpec);
            AlgorithmIdentifier algorithmIdentifier2 = this._encAlg;
            String string3 = algorithmIdentifier2.getObjectId().getId();
            Key key2 = cipher.unwrap(byArray, string3, 3);
            return this.getContentFromSessionKey(key2, string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("invalid iv.", invalidAlgorithmParameterException);
        }
    }
}

