/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.RedisAsyncCommandsImpl;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.pubsub.PubSubCommandBuilder;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.api.async.RedisPubSubAsyncCommands;
import java.util.List;
import java.util.Map;

public class RedisPubSubAsyncCommandsImpl<K, V>
extends RedisAsyncCommandsImpl<K, V>
implements RedisPubSubConnection<K, V>,
RedisPubSubAsyncCommands<K, V> {
    private final PubSubCommandBuilder<K, V> commandBuilder;

    public RedisPubSubAsyncCommandsImpl(StatefulRedisPubSubConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
        this.commandBuilder = new PubSubCommandBuilder<K, V>(codec);
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.getStatefulConnection().addListener(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.getStatefulConnection().removeListener(listener);
    }

    @Override
    public RedisFuture<Void> psubscribe(K ... patterns) {
        return this.dispatch(this.commandBuilder.psubscribe(patterns));
    }

    @Override
    public RedisFuture<Void> punsubscribe(K ... patterns) {
        return this.dispatch(this.commandBuilder.punsubscribe(patterns));
    }

    @Override
    public RedisFuture<Void> subscribe(K ... channels) {
        return this.dispatch(this.commandBuilder.subscribe(channels));
    }

    @Override
    public RedisFuture<Void> unsubscribe(K ... channels) {
        return this.dispatch(this.commandBuilder.unsubscribe(channels));
    }

    @Override
    public RedisFuture<Long> publish(K channel, V message) {
        return this.dispatch(this.commandBuilder.publish(channel, message));
    }

    @Override
    public RedisFuture<List<K>> pubsubChannels(K channel) {
        return this.dispatch(this.commandBuilder.pubsubChannels(channel));
    }

    @Override
    public RedisFuture<Map<K, Long>> pubsubNumsub(K ... channels) {
        return this.dispatch(this.commandBuilder.pubsubNumsub(channels));
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getStatefulConnection() {
        return (StatefulRedisPubSubConnection)super.getStatefulConnection();
    }
}

