/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.MapOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ListOfMapsOutput<K, V>
extends CommandOutput<K, V, List<Map<K, V>>> {
    private MapOutput<K, V> nested;
    private int mapCount = -1;
    private final List<Integer> counts = new ArrayList<Integer>();

    public ListOfMapsOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.nested = new MapOutput<K, V>(codec);
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.nested.set(bytes);
    }

    @Override
    public void complete(int depth) {
        if (!this.counts.isEmpty()) {
            int expectedSize = this.counts.get(0);
            if (((Map)this.nested.get()).size() == expectedSize) {
                this.counts.remove(0);
                ((List)this.output).add(new LinkedHashMap((Map)this.nested.get()));
                ((Map)this.nested.get()).clear();
            }
        }
    }

    @Override
    public void multi(int count) {
        this.nested.multi(count);
        if (this.mapCount == -1) {
            this.mapCount = count;
        } else {
            this.counts.add(count / 2);
        }
    }
}

