/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulConnection;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.internal.LettuceSets;
import com.lambdaworks.redis.masterslave.MasterSlaveUtils;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class MasterSlaveConnectionProvider<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterSlaveConnectionProvider.class);
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final Map<ConnectionKey, StatefulRedisConnection<K, V>> connections = new ConcurrentHashMap<ConnectionKey, StatefulRedisConnection<K, V>>();
    private final ConnectionFactory<K, V> connectionFactory;
    private final RedisURI initialRedisUri;
    private List<RedisNodeDescription> knownNodes = new ArrayList<RedisNodeDescription>();
    private boolean autoFlushCommands = true;
    private Object stateLock = new Object();
    private ReadFrom readFrom;

    @Deprecated
    public MasterSlaveConnectionProvider(RedisClient redisClient, RedisCodec<K, V> redisCodec, StatefulRedisConnection<K, V> masterConnection, RedisURI initialRedisUri) {
        this.initialRedisUri = initialRedisUri;
        this.connectionFactory = new ConnectionFactory<K, V>(redisClient, redisCodec);
        this.connections.put(this.toConnectionKey(initialRedisUri), masterConnection);
    }

    MasterSlaveConnectionProvider(RedisClient redisClient, RedisCodec<K, V> redisCodec, RedisURI initialRedisUri, Map<RedisURI, StatefulRedisConnection<K, V>> initialConnections) {
        this.initialRedisUri = initialRedisUri;
        this.connectionFactory = new ConnectionFactory<K, V>(redisClient, redisCodec);
        for (Map.Entry<RedisURI, StatefulRedisConnection<K, V>> entry : initialConnections.entrySet()) {
            this.connections.put(this.toConnectionKey(entry.getKey()), entry.getValue());
        }
    }

    public StatefulRedisConnection<K, V> getConnection(Intent intent) {
        if (this.debugEnabled) {
            logger.debug("getConnection(" + (Object)((Object)intent) + ")");
        }
        if (this.readFrom != null && intent == Intent.READ) {
            List<RedisNodeDescription> selection = this.readFrom.select(new ReadFrom.Nodes(){

                @Override
                public List<RedisNodeDescription> getNodes() {
                    return MasterSlaveConnectionProvider.this.knownNodes;
                }

                @Override
                public Iterator<RedisNodeDescription> iterator() {
                    return MasterSlaveConnectionProvider.this.knownNodes.iterator();
                }
            });
            if (selection.isEmpty()) {
                throw new RedisException(String.format("Cannot determine a node to read (Known nodes: %s) with setting %s", this.knownNodes, this.readFrom));
            }
            try {
                for (RedisNodeDescription redisNodeDescription : selection) {
                    StatefulRedisConnection<K, V> readerCandidate = this.getConnection(redisNodeDescription);
                    if (!readerCandidate.isOpen()) continue;
                    return readerCandidate;
                }
                return this.getConnection(selection.get(0));
            }
            catch (RuntimeException e) {
                throw new RedisException(e);
            }
        }
        return this.getConnection(this.getMaster());
    }

    protected StatefulRedisConnection<K, V> getConnection(RedisNodeDescription redisNodeDescription) {
        return this.connections.computeIfAbsent(new ConnectionKey(redisNodeDescription.getUri().getHost(), redisNodeDescription.getUri().getPort()), this.connectionFactory);
    }

    protected long getConnectionCount() {
        return this.connections.size();
    }

    private Set<ConnectionKey> getStaleConnectionKeys() {
        HashMap<ConnectionKey, StatefulRedisConnection<K, V>> map = new HashMap<ConnectionKey, StatefulRedisConnection<K, V>>(this.connections);
        HashSet<ConnectionKey> stale = new HashSet<ConnectionKey>();
        for (ConnectionKey connectionKey : map.keySet()) {
            if (connectionKey.host != null && MasterSlaveUtils.findNodeByHostAndPort(this.knownNodes, connectionKey.host, connectionKey.port) != null) continue;
            stale.add(connectionKey);
        }
        return stale;
    }

    public void closeStaleConnections() {
        logger.debug("closeStaleConnections() count before expiring: {}", (Object)this.getConnectionCount());
        Set<ConnectionKey> stale = this.getStaleConnectionKeys();
        for (ConnectionKey connectionKey : stale) {
            StatefulRedisConnection<K, V> connection = this.connections.get(connectionKey);
            if (connection == null) continue;
            this.connections.remove(connectionKey);
            connection.close();
        }
        logger.debug("closeStaleConnections() count after expiring: {}", (Object)this.getConnectionCount());
    }

    public void reset() {
        this.allConnections().forEach(StatefulConnection::reset);
    }

    public void close() {
        Collection<StatefulRedisConnection<K, V>> connections = this.allConnections();
        this.connections.clear();
        connections.forEach(StatefulConnection::close);
    }

    public void flushCommands() {
        this.allConnections().forEach(StatefulConnection::flushCommands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoFlushCommands(boolean autoFlushCommands) {
        Object object = this.stateLock;
        synchronized (object) {
        }
        this.allConnections().forEach(connection -> connection.setAutoFlushCommands(autoFlushCommands));
    }

    protected Collection<StatefulRedisConnection<K, V>> allConnections() {
        Set<StatefulRedisConnection<K, V>> connections = LettuceSets.newHashSet(this.connections.values());
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKnownNodes(Collection<RedisNodeDescription> knownNodes) {
        Object object = this.stateLock;
        synchronized (object) {
            this.knownNodes.clear();
            this.knownNodes.addAll(knownNodes);
            this.closeStaleConnections();
        }
    }

    public ReadFrom getReadFrom() {
        return this.readFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadFrom(ReadFrom readFrom) {
        Object object = this.stateLock;
        synchronized (object) {
            this.readFrom = readFrom;
        }
    }

    public RedisNodeDescription getMaster() {
        for (RedisNodeDescription knownNode : this.knownNodes) {
            if (knownNode.getRole() != RedisInstance.Role.MASTER) continue;
            return knownNode;
        }
        throw new RedisException(String.format("Master is currently unknown: %s", this.knownNodes));
    }

    private ConnectionKey toConnectionKey(RedisURI redisURI) {
        return new ConnectionKey(redisURI.getHost(), redisURI.getPort());
    }

    static enum Intent {
        READ,
        WRITE;

    }

    private static class ConnectionKey {
        private final String host;
        private final int port;

        public ConnectionKey(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectionKey)) {
                return false;
            }
            ConnectionKey that = (ConnectionKey)o;
            if (this.port != that.port) {
                return false;
            }
            return !(this.host == null ? that.host != null : !this.host.equals(that.host));
        }

        public int hashCode() {
            int result = this.host != null ? this.host.hashCode() : 0;
            result = 31 * result + this.port;
            return result;
        }
    }

    private class ConnectionFactory<K, V>
    implements Function<ConnectionKey, StatefulRedisConnection<K, V>> {
        private final RedisClient redisClient;
        private final RedisCodec<K, V> redisCodec;

        public ConnectionFactory(RedisClient redisClient, RedisCodec<K, V> redisCodec) {
            this.redisClient = redisClient;
            this.redisCodec = redisCodec;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatefulRedisConnection<K, V> apply(ConnectionKey key) {
            RedisURI.Builder builder = RedisURI.Builder.redis(key.host, key.port);
            if (MasterSlaveConnectionProvider.this.initialRedisUri.getPassword() != null && MasterSlaveConnectionProvider.this.initialRedisUri.getPassword().length != 0) {
                builder.withPassword(MasterSlaveConnectionProvider.this.initialRedisUri.getPassword());
            }
            if (MasterSlaveConnectionProvider.this.initialRedisUri.getClientName() != null) {
                builder.withClientName(MasterSlaveConnectionProvider.this.initialRedisUri.getClientName());
            }
            builder.withDatabase(MasterSlaveConnectionProvider.this.initialRedisUri.getDatabase());
            StatefulRedisConnection<K, V> connection = this.redisClient.connect(this.redisCodec, builder.build());
            Object object = MasterSlaveConnectionProvider.this.stateLock;
            synchronized (object) {
                connection.setAutoFlushCommands(MasterSlaveConnectionProvider.this.autoFlushCommands);
            }
            return connection;
        }
    }
}

