/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.pubsub.api.rx;

import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import com.lambdaworks.redis.cluster.pubsub.api.rx.PubSubReactiveNodeSelection;
import com.lambdaworks.redis.pubsub.api.rx.RedisPubSubReactiveCommands;
import java.util.function.Predicate;

public interface RedisClusterPubSubReactiveCommands<K, V>
extends RedisPubSubReactiveCommands<K, V> {
    @Override
    public StatefulRedisClusterPubSubConnection<K, V> getStatefulConnection();

    default public PubSubReactiveNodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    default public PubSubReactiveNodeSelection<K, V> slaves() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public PubSubReactiveNodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.nodes(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public PubSubReactiveNodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public PubSubReactiveNodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);
}

