package aQute.lib.header;

import java.util.*;

import aQute.lib.qtokens.*;
import aQute.lib.reporter.*;

public class OSGiHeader {
	
	static public Map parseHeader(String value) {
		return parseHeader(value, null);
	}
	/**
	 * Standard OSGi header parser. This parser can handle the format clauses
	 * ::= clause ( ',' clause ) + clause ::= name ( ';' name ) (';' key '='
	 * value )
	 * 
	 * This is mapped to a Map { name => Map { attr|directive => value } }
	 * 
	 * @param value A string 
	 * @return a Map<String,Map<String,String>>
	 */
	static public Map parseHeader(String value, Reporter logger) {
		if (value == null || value.trim().length() == 0)
			return new HashMap();

		Map result = new LinkedHashMap();
		QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
		char del = 0;
		do {
			boolean hadAttribute = false;
			Map clause = new HashMap();
			List aliases = new ArrayList();
			String name = qt.nextToken();

			del = qt.getSeparator();
			if (name == null || name.length() == 0) {
				if (logger != null && logger.isPedantic()) {
					logger
							.warning("Empty clause, usually caused by repeating a comma without any name field or by having spaces after the backslash of a property file: "
									+ value);
				}
				if (name == null)
					break;
			} else {
				name = name.trim();
				aliases.add(name);
				while (del == ';') {
					String adname = qt.nextToken();
					if ((del = qt.getSeparator()) != '=') {
						if (hadAttribute)
							if (logger != null) {
								logger
										.error("Header contains name field after attribute or directive: "
												+ adname
												+ " from "
												+ value
												+ ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4");
							}
						if (adname !=null && adname.length() > 0)
							aliases.add(adname.trim());
					} else {
						String advalue = qt.nextToken();
						if (clause.containsKey(adname)) {
							if (logger != null && logger.isPedantic())
								logger
										.warning("Duplicate attribute/directive name "
												+ adname
												+ " in "
												+ value
												+ ". This attribute/directive will be ignored");
						}
						clause.put(adname.trim(), advalue.trim());
						del = qt.getSeparator();
						hadAttribute = true;
					}
				}
				for (Iterator i = aliases.iterator(); i.hasNext();) {
					String clauseName = (String) i.next();
					if (result.containsKey(clauseName)) {
						if (logger != null && logger.isPedantic())
							logger
									.warning("Duplicate name "
											+ clauseName
											+ " used in header: '"
											+ clauseName
											+ "'. Duplicate names in one clause not supported in Bnd.");
					} else
						result.put(clauseName, clause);
				}
			}
		} while (del == ',');
		return result;
	}

}
