/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.service.MakePlugin;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.JarResource;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeBnd
implements MakePlugin,
Constants {
    static final Pattern JARFILE = Pattern.compile("(.+)\\.(jar|ipa)");

    @Override
    public Resource make(Builder builder, String destination, Map<String, String> argumentsOnMake) throws Exception {
        String type = argumentsOnMake.get("type");
        if (!"bnd".equals(type)) {
            return null;
        }
        String recipe = argumentsOnMake.get("recipe");
        if (recipe == null) {
            builder.error("No recipe specified on a make instruction for " + destination, new Object[0]);
            return null;
        }
        File bndfile = builder.getFile(recipe);
        if (bndfile.isFile()) {
            Builder bchild = builder.getSubBuilder();
            bchild.removeBundleSpecificHeaders();
            bchild.setProperty("Include-Resource", "");
            bchild.setProperty("-includeresource", "");
            bchild.setProperties(bndfile, builder.getBase());
            Jar jar = bchild.build();
            Jar dot = builder.getTarget();
            if (builder.hasSources()) {
                for (String key : jar.getResources().keySet()) {
                    if (!key.startsWith("OSGI-OPT/src")) continue;
                    dot.putResource(key, jar.getResource(key));
                }
            }
            builder.getInfo(bchild, String.valueOf(bndfile.getName()) + ": ");
            String debug = bchild.getProperty("-debug");
            if (Processor.isTrue(debug) && builder instanceof ProjectBuilder) {
                ProjectBuilder pb = (ProjectBuilder)builder;
                File target = pb.getProject().getTarget();
                String bsn = bchild.getBsn();
                File output = new File(target, String.valueOf(bsn) + ".jar");
                jar.write(output);
                pb.getProject().getWorkspace().changedFile(output);
            }
            return new JarResource(jar);
        }
        return null;
    }
}

