/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.WriteLockInfo;

public class ReadCommittedLocker
extends BuddyLocker {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReadCommittedLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        super(env, buddy instanceof ReadCommittedLocker ? ((ReadCommittedLocker)buddy).getBuddy() : buddy);
        if (!$assertionsDisabled && !this.getBuddy().isTransactional()) {
            throw new AssertionError();
        }
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        return new ReadCommittedLocker(this.envImpl, this.getBuddy().newNonTxnLocker());
    }

    LockResult lockInternal(long nodeId, LockType lockType, boolean noWait, DatabaseImpl database) throws DatabaseException {
        if (lockType.isWriteLock()) {
            return this.getBuddy().lockInternal(nodeId, lockType, noWait, database);
        }
        return super.lockInternal(nodeId, lockType, noWait, database);
    }

    public void releaseLock(long nodeId) throws DatabaseException {
        if (!this.lockManager.release(nodeId, this)) {
            this.lockManager.release(nodeId, this.getBuddy());
        }
        this.removeLock(nodeId);
    }

    public boolean createdNode(long nodeId) throws DatabaseException {
        return this.getBuddy().createdNode(nodeId);
    }

    public long getAbortLsn(long nodeId) throws DatabaseException {
        return this.getBuddy().getAbortLsn(nodeId);
    }

    public WriteLockInfo getWriteLockInfo(long nodeId) throws DatabaseException {
        return this.getBuddy().getWriteLockInfo(nodeId);
    }

    public void addDeleteInfo(BIN bin, Key deletedKey) throws DatabaseException {
        this.getBuddy().addDeleteInfo(bin, deletedKey);
    }

    public void registerCursor(CursorImpl cursor) throws DatabaseException {
        this.getBuddy().registerCursor(cursor);
    }

    public void unRegisterCursor(CursorImpl cursor) throws DatabaseException {
        this.getBuddy().unRegisterCursor(cursor);
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean isReadCommittedIsolation() {
        return true;
    }

    static {
        $assertionsDisabled = !ReadCommittedLocker.class.desiredAssertionStatus();
    }
}

