/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DeltaInfo;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BINDelta
implements Loggable {
    private DatabaseId dbId;
    private long lastFullLsn;
    private List deltas;
    private LogEntryType logEntryType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BINDelta(BIN bin) {
        this.lastFullLsn = bin.getLastFullVersion();
        this.dbId = bin.getDatabaseId();
        this.deltas = new ArrayList();
        this.logEntryType = bin.getBINDeltaType();
        for (int i = 0; i < bin.getNEntries(); ++i) {
            if (!bin.isDirty(i)) continue;
            this.deltas.add(new DeltaInfo(bin.getKey(i), bin.getLsn(i), bin.getState(i)));
        }
    }

    public BINDelta() {
        this.dbId = new DatabaseId();
        this.lastFullLsn = -1L;
        this.deltas = new ArrayList();
    }

    int getNumDeltas() {
        return this.deltas.size();
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getLastFullLsn() {
        return this.lastFullLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIN reconstituteBIN(EnvironmentImpl env) throws DatabaseException {
        BIN fullBIN = (BIN)env.getLogManager().get(this.lastFullLsn);
        DatabaseImpl db = env.getDbMapTree().getDb(this.dbId);
        try {
            fullBIN.setDatabase(db);
            fullBIN.setLastFullLsn(this.lastFullLsn);
            fullBIN.latch();
            for (int i = 0; i < this.deltas.size(); ++i) {
                DeltaInfo info = (DeltaInfo)this.deltas.get(i);
                int foundIndex = fullBIN.findEntry(info.getKey(), true, false);
                if (foundIndex >= 0 && (foundIndex & 0x10000) != 0) {
                    foundIndex &= 0xFFFEFFFF;
                    if (info.isKnownDeleted()) {
                        fullBIN.setKnownDeleted(foundIndex);
                        continue;
                    }
                    fullBIN.updateEntry(foundIndex, info.getLsn(), info.getState());
                    continue;
                }
                if (info.isKnownDeleted()) continue;
                ChildReference entry = new ChildReference(null, info.getKey(), info.getLsn(), info.getState());
                boolean insertOk = fullBIN.insertEntry(entry);
                if (!$assertionsDisabled && !insertOk) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            env.releaseDb(db);
        }
        fullBIN.setGeneration(0L);
        fullBIN.releaseLatch();
        return fullBIN;
    }

    public int getLogSize() {
        int size = this.dbId.getLogSize() + 8 + 4;
        for (int i = 0; i < this.deltas.size(); ++i) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            size += info.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        this.dbId.writeToLog(logBuffer);
        LogUtils.writeLong(logBuffer, this.lastFullLsn);
        LogUtils.writeInt(logBuffer, this.deltas.size());
        for (int i = 0; i < this.deltas.size(); ++i) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            info.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        this.dbId.readFromLog(itemBuffer, entryTypeVersion);
        this.lastFullLsn = LogUtils.readLong(itemBuffer);
        int numDeltas = LogUtils.readInt(itemBuffer);
        for (int i = 0; i < numDeltas; ++i) {
            DeltaInfo info = new DeltaInfo();
            info.readFromLog(itemBuffer, entryTypeVersion);
            this.deltas.add(info);
        }
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        this.dbId.dumpLog(sb, verbose);
        sb.append("<lastFullLsn>");
        sb.append(DbLsn.toString(this.lastFullLsn));
        sb.append("</lastFullLsn>");
        sb.append("<deltas size=\"").append(this.deltas.size()).append("\"/>");
        for (int i = 0; i < this.deltas.size(); ++i) {
            DeltaInfo info = (DeltaInfo)this.deltas.get(i);
            info.dumpLog(sb, verbose);
        }
    }

    public long getTransactionId() {
        return 0L;
    }

    static {
        $assertionsDisabled = !BINDelta.class.desiredAssertionStatus();
    }
}

